/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;

@Immutable
public class RuleImpl
implements Rule {
    private final int id;
    private final RuleKey key;
    private final String name;
    private final RuleStatus status;
    private final Set<String> tags;
    private final DebtRemediationFunction remediationFunction;
    private final RuleType type;
    private final String pluginKey;

    public RuleImpl(RuleDto dto) {
        this.id = dto.getId();
        this.key = dto.getKey();
        this.name = dto.getName();
        this.status = dto.getStatus();
        this.tags = Sets.union((Set)dto.getSystemTags(), (Set)dto.getTags());
        this.remediationFunction = RuleImpl.effectiveRemediationFunction(dto);
        this.type = RuleType.valueOf((int)dto.getType());
        this.pluginKey = dto.getPluginKey();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public RuleKey getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RuleStatus getStatus() {
        return this.status;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public DebtRemediationFunction getRemediationFunction() {
        return this.remediationFunction;
    }

    @Override
    public RuleType getType() {
        return this.type;
    }

    @Override
    @CheckForNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleImpl rule = (RuleImpl)o;
        return this.key.equals((Object)rule.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("key", (Object)this.key).add("name", (Object)this.name).add("status", (Object)this.status).add("tags", this.tags).add("pluginKey", (Object)this.pluginKey).toString();
    }

    @CheckForNull
    private static DebtRemediationFunction effectiveRemediationFunction(RuleDto dto) {
        String fn = dto.getRemediationFunction();
        if (fn != null) {
            return new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.valueOf((String)fn), dto.getRemediationGapMultiplier(), dto.getRemediationBaseEffort());
        }
        String defaultFn = dto.getDefRemediationFunction();
        if (defaultFn != null) {
            return new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.valueOf((String)defaultFn), dto.getDefRemediationGapMultiplier(), dto.getDefRemediationBaseEffort());
        }
        return null;
    }
}

