/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.sonar.api.issue.IssueComment;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.Uuids;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.issue.DebtCalculator;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.IssueWorkflow;

public class IssueLifecycle {
    private final IssueWorkflow workflow;
    private final IssueChangeContext changeContext;
    private final IssueFieldsSetter updater;
    private final DebtCalculator debtCalculator;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public IssueLifecycle(AnalysisMetadataHolder analysisMetadataHolder, IssueWorkflow workflow, IssueFieldsSetter updater, DebtCalculator debtCalculator) {
        this(analysisMetadataHolder, IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate())), workflow, updater, debtCalculator);
    }

    @VisibleForTesting
    IssueLifecycle(AnalysisMetadataHolder analysisMetadataHolder, IssueChangeContext changeContext, IssueWorkflow workflow, IssueFieldsSetter updater, DebtCalculator debtCalculator) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.workflow = workflow;
        this.updater = updater;
        this.debtCalculator = debtCalculator;
        this.changeContext = changeContext;
    }

    public void initNewOpenIssue(DefaultIssue issue) {
        issue.setKey(Uuids.create());
        issue.setCreationDate(this.changeContext.date());
        issue.setUpdateDate(this.changeContext.date());
        issue.setStatus("OPEN");
        issue.setEffort(this.debtCalculator.calculate(issue));
    }

    public void copyExistingOpenIssueFromLongLivingBranch(DefaultIssue raw, DefaultIssue base, String fromLongBranchName) {
        raw.setKey(Uuids.create());
        raw.setNew(false);
        this.copyIssueAttributes(raw, base);
        raw.setFieldChange(this.changeContext, "from_long_branch", (Serializable)((Object)fromLongBranchName), (Serializable)((Object)this.analysisMetadataHolder.getBranch().getName()));
    }

    public void mergeConfirmedOrResolvedFromShortLivingBranch(DefaultIssue raw, DefaultIssue base, String fromShortBranchName) {
        this.copyIssueAttributes(raw, base);
        raw.setFieldChange(this.changeContext, "from_short_branch", (Serializable)((Object)fromShortBranchName), (Serializable)((Object)this.analysisMetadataHolder.getBranch().getName()));
    }

    private void copyIssueAttributes(DefaultIssue to, DefaultIssue from) {
        to.setCopied(true);
        this.copyFields(to, from);
        if (from.manualSeverity()) {
            to.setManualSeverity(true);
            to.setSeverity(from.severity());
        }
        IssueLifecycle.copyChanges(to, from);
    }

    private static void copyChanges(DefaultIssue raw, DefaultIssue base) {
        base.comments().forEach(c -> raw.addComment(IssueLifecycle.copy(raw.key(), c)));
        base.changes().forEach(c -> IssueLifecycle.copy(raw.key(), c).ifPresent(arg_0 -> ((DefaultIssue)raw).addChange(arg_0)));
    }

    private static DefaultIssueComment copy(String issueKey, IssueComment c) {
        DefaultIssueComment comment = new DefaultIssueComment();
        comment.setIssueKey(issueKey);
        comment.setKey(Uuids.create());
        comment.setUserLogin(c.userLogin());
        comment.setMarkdownText(c.markdownText());
        comment.setCreatedAt(c.createdAt()).setUpdatedAt(c.updatedAt());
        comment.setNew(true);
        return comment;
    }

    private static Optional<FieldDiffs> copy(String issueKey, FieldDiffs c) {
        FieldDiffs result = new FieldDiffs();
        result.setIssueKey(issueKey);
        result.setUserLogin(c.userLogin());
        result.setCreationDate(c.creationDate());
        c.diffs().entrySet().stream().filter(e -> !((String)e.getKey()).equals("file")).forEach(e -> result.setDiff((String)e.getKey(), ((FieldDiffs.Diff)e.getValue()).oldValue(), ((FieldDiffs.Diff)e.getValue()).newValue()));
        if (result.diffs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public void mergeExistingOpenIssue(DefaultIssue raw, DefaultIssue base) {
        raw.setKey(base.key());
        raw.setNew(false);
        this.copyFields(raw, base);
        if (base.manualSeverity()) {
            raw.setManualSeverity(true);
            raw.setSeverity(base.severity());
        } else {
            this.updater.setPastSeverity(raw, base.severity(), this.changeContext);
        }
        raw.setComponentUuid(base.componentUuid());
        raw.setComponentKey(base.componentKey());
        raw.setModuleUuid(base.moduleUuid());
        raw.setModuleUuidPath(base.moduleUuidPath());
        this.updater.setPastLine(raw, base.getLine());
        this.updater.setPastLocations(raw, base.getLocations());
        this.updater.setPastMessage(raw, base.getMessage(), this.changeContext);
        this.updater.setPastGap(raw, base.gap(), this.changeContext);
        this.updater.setPastEffort(raw, base.effort(), this.changeContext);
    }

    public void doAutomaticTransition(DefaultIssue issue) {
        this.workflow.doAutomaticTransition(issue, this.changeContext);
    }

    private void copyFields(DefaultIssue toIssue, DefaultIssue fromIssue) {
        toIssue.setType(fromIssue.type());
        toIssue.setCreationDate(fromIssue.creationDate());
        toIssue.setUpdateDate(fromIssue.updateDate());
        toIssue.setCloseDate(fromIssue.closeDate());
        toIssue.setResolution(fromIssue.resolution());
        toIssue.setStatus(fromIssue.status());
        toIssue.setAssignee(fromIssue.assignee());
        toIssue.setAuthorLogin(fromIssue.authorLogin());
        toIssue.setTags((Collection)fromIssue.tags());
        toIssue.setAttributes(fromIssue.attributes());
        toIssue.setEffort(this.debtCalculator.calculate(toIssue));
        toIssue.setOnDisabledRule(fromIssue.isOnDisabledRule());
        toIssue.setSelectedAt(fromIssue.selectedAt());
    }
}

