/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.HashMap;
import java.util.Map;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;

public class EffortAggregator
extends IssueVisitor {
    private final MeasureRepository measureRepository;
    private final Metric maintainabilityEffortMetric;
    private final Metric reliabilityEffortMetric;
    private final Metric securityEffortMetric;
    private final Map<Integer, EffortCounter> effortsByComponentRef = new HashMap<Integer, EffortCounter>();
    private EffortCounter effortCounter;

    public EffortAggregator(MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.measureRepository = measureRepository;
        this.maintainabilityEffortMetric = metricRepository.getByKey("sqale_index");
        this.reliabilityEffortMetric = metricRepository.getByKey("reliability_remediation_effort");
        this.securityEffortMetric = metricRepository.getByKey("security_remediation_effort");
    }

    @Override
    public void beforeComponent(Component component) {
        this.effortCounter = new EffortCounter();
        this.effortsByComponentRef.put(component.getReportAttributes().getRef(), this.effortCounter);
        for (Component child : component.getChildren()) {
            EffortCounter childEffortCounter = this.effortsByComponentRef.remove(child.getReportAttributes().getRef());
            if (childEffortCounter == null) continue;
            this.effortCounter.add(childEffortCounter);
        }
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.resolution() == null) {
            this.effortCounter.add(issue);
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.computeMaintainabilityEffortMeasure(component);
        this.computeReliabilityEffortMeasure(component);
        this.computeSecurityEffortMeasure(component);
        this.effortCounter = null;
    }

    private void computeMaintainabilityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.maintainabilityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.maintainabilityEffort));
    }

    private void computeReliabilityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.reliabilityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.reliabilityEffort));
    }

    private void computeSecurityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.securityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.securityEffort));
    }

    private class EffortCounter {
        private long maintainabilityEffort = 0L;
        private long reliabilityEffort = 0L;
        private long securityEffort = 0L;

        private EffortCounter() {
        }

        void add(DefaultIssue issue) {
            Long issueEffort = issue.effortInMinutes();
            if (issueEffort != null && issueEffort != 0L) {
                switch (issue.type()) {
                    case CODE_SMELL: {
                        this.maintainabilityEffort += issueEffort.longValue();
                        break;
                    }
                    case BUG: {
                        this.reliabilityEffort += issueEffort.longValue();
                        break;
                    }
                    case VULNERABILITY: {
                        this.securityEffort += issueEffort.longValue();
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown type '%s'", issue.type()));
                    }
                }
            }
        }

        public void add(EffortCounter effortCounter) {
            this.maintainabilityEffort += effortCounter.maintainabilityEffort;
            this.reliabilityEffort += effortCounter.reliabilityEffort;
            this.securityEffort += effortCounter.securityEffort;
        }
    }
}

