/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.coverage;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public final class CoverageUtils {
    private static final Measure DEFAULT_MEASURE = Measure.newMeasureBuilder().create(0L);

    private CoverageUtils() {
    }

    static double calculateCoverage(long coveredLines, long lines) {
        return 100.0 * (double)coveredLines / (double)lines;
    }

    static long getLongMeasureValue(CounterInitializationContext counterContext, String metricKey) {
        Measure measure = (Measure)counterContext.getMeasure(metricKey).or((Object)DEFAULT_MEASURE);
        if (measure.getValueType() == Measure.ValueType.NO_VALUE) {
            return 0L;
        }
        if (measure.getValueType() == Measure.ValueType.INT) {
            return measure.getIntValue();
        }
        return measure.getLongValue();
    }

    static double getMeasureVariations(CounterInitializationContext counterContext, String metricKey) {
        Optional<Measure> measure = counterContext.getMeasure(metricKey);
        if (!measure.isPresent() || !((Measure)measure.get()).hasVariation()) {
            return 0.0;
        }
        return ((Measure)measure.get()).getVariation();
    }
}

