/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.duplication;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class TextBlock
implements Comparable<TextBlock> {
    private final int start;
    private final int end;

    public TextBlock(int start, int end) {
        Preconditions.checkArgument((start > 0 ? 1 : 0) != 0, (Object)"First line index must be >= 1");
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"Last line index must be >= first line index");
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(TextBlock other) {
        int res = this.start - other.start;
        if (res == 0) {
            return this.end - other.end;
        }
        return res;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBlock textBlock = (TextBlock)o;
        return this.start == textBlock.start && this.end == textBlock.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "TextBlock{start=" + this.start + ", end=" + this.end + '}';
    }
}

