/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.duplication;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplication;
import org.sonar.server.computation.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;

public class DuplicationMeasures {
    protected final ImmutableList<Formula> formulas;
    protected final TreeRootHolder treeRootHolder;
    protected final MetricRepository metricRepository;
    protected final MeasureRepository measureRepository;
    private final DuplicationRepository duplicationRepository;

    public DuplicationMeasures(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, @Nullable DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.duplicationRepository = duplicationRepository;
        this.formulas = ImmutableList.of((Object)new DuplicationFormula(metricRepository, measureRepository));
    }

    public DuplicationMeasures(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this(treeRootHolder, metricRepository, measureRepository, null);
    }

    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)this.formulas)).visit(this.treeRootHolder.getRoot());
    }

    protected DuplicationCounter createCounter() {
        return new DuplicationCounter(this.duplicationRepository);
    }

    private final class DuplicationFormula
    implements Formula<DuplicationCounter> {
        private final MeasureRepository measureRepository;
        private final Metric nclocMetric;
        private final Metric linesMetric;
        private final Metric commentLinesMetric;

        private DuplicationFormula(MetricRepository metricRepository, MeasureRepository measureRepository) {
            this.measureRepository = measureRepository;
            this.nclocMetric = metricRepository.getByKey("ncloc");
            this.linesMetric = metricRepository.getByKey("lines");
            this.commentLinesMetric = metricRepository.getByKey("comment_lines");
        }

        @Override
        public DuplicationCounter createNewCounter() {
            return DuplicationMeasures.this.createCounter();
        }

        @Override
        public com.google.common.base.Optional<Measure> createMeasure(DuplicationCounter counter, CreateMeasureContext context) {
            switch (context.getMetric().getKey()) {
                case "duplicated_files": {
                    return com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().create(counter.fileCount));
                }
                case "duplicated_lines": {
                    return com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().create(counter.lineCount));
                }
                case "duplicated_lines_density": {
                    return this.createDuplicatedLinesDensityMeasure(counter, context);
                }
                case "duplicated_blocks": {
                    return com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().create(counter.blockCount));
                }
            }
            throw new IllegalArgumentException("Unsupported metric " + context.getMetric());
        }

        private com.google.common.base.Optional<Measure> createDuplicatedLinesDensityMeasure(DuplicationCounter counter, CreateMeasureContext context) {
            int duplicatedLines = counter.lineCount;
            Optional<Integer> nbLines = this.getNbLinesFromLocOrNcloc(context);
            if (nbLines.isPresent() && nbLines.get() > 0) {
                double density = Math.min(100.0, 100.0 * (double)duplicatedLines / (double)nbLines.get().intValue());
                return com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().create(density, context.getMetric().getDecimalScale()));
            }
            return com.google.common.base.Optional.absent();
        }

        private Optional<Integer> getNbLinesFromLocOrNcloc(CreateMeasureContext context) {
            com.google.common.base.Optional<Measure> lines = this.measureRepository.getRawMeasure(context.getComponent(), this.linesMetric);
            if (lines.isPresent()) {
                return Optional.of(((Measure)lines.get()).getIntValue());
            }
            com.google.common.base.Optional<Measure> nclocs = this.measureRepository.getRawMeasure(context.getComponent(), this.nclocMetric);
            if (nclocs.isPresent()) {
                com.google.common.base.Optional<Measure> commentLines = this.measureRepository.getRawMeasure(context.getComponent(), this.commentLinesMetric);
                int nbLines = ((Measure)nclocs.get()).getIntValue();
                return Optional.of(commentLines.isPresent() ? nbLines + ((Measure)commentLines.get()).getIntValue() : nbLines);
            }
            return Optional.empty();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"duplicated_files", "duplicated_lines", "duplicated_lines_density", "duplicated_blocks"};
        }
    }

    protected static class DuplicationCounter
    implements Counter<DuplicationCounter> {
        @CheckForNull
        private final DuplicationRepository duplicationRepository;
        protected int fileCount = 0;
        protected int blockCount = 0;
        protected int lineCount = 0;

        protected DuplicationCounter() {
            this(null);
        }

        private DuplicationCounter(@Nullable DuplicationRepository duplicationRepository) {
            this.duplicationRepository = duplicationRepository;
        }

        @Override
        public void aggregate(DuplicationCounter counter) {
            this.fileCount += counter.fileCount;
            this.blockCount += counter.blockCount;
            this.lineCount += counter.lineCount;
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component leaf = context.getLeaf();
            if (leaf.getType() == Component.Type.FILE) {
                this.initializeForFile(leaf);
            } else if (leaf.getType() == Component.Type.PROJECT_VIEW) {
                this.initializeForProjectView(context);
            }
        }

        protected void initializeForFile(Component file) {
            Iterable<Duplication> duplications = Objects.requireNonNull(this.duplicationRepository, "DuplicationRepository missing").getDuplications(file);
            if (Iterables.isEmpty(duplications)) {
                return;
            }
            HashSet<Integer> duplicatedLineNumbers = new HashSet<Integer>();
            long blocks = 0L;
            for (Duplication duplication : duplications) {
                ++blocks;
                DuplicationCounter.addLines(duplication.getOriginal(), duplicatedLineNumbers);
                for (InnerDuplicate innerDuplicate : FluentIterable.from(duplication.getDuplicates()).filter(InnerDuplicate.class)) {
                    ++blocks;
                    DuplicationCounter.addLines(innerDuplicate.getTextBlock(), duplicatedLineNumbers);
                }
            }
            ++this.fileCount;
            this.blockCount = (int)((long)this.blockCount + blocks);
            this.lineCount += duplicatedLineNumbers.size();
        }

        private static void addLines(TextBlock textBlock, Set<Integer> duplicatedLineNumbers) {
            for (int i = textBlock.getStart(); i <= textBlock.getEnd(); ++i) {
                duplicatedLineNumbers.add(i);
            }
        }

        private void initializeForProjectView(CounterInitializationContext context) {
            this.fileCount += DuplicationCounter.getMeasure(context, "duplicated_files");
            this.blockCount += DuplicationCounter.getMeasure(context, "duplicated_blocks");
            this.lineCount += DuplicationCounter.getMeasure(context, "duplicated_lines");
        }

        private static int getMeasure(CounterInitializationContext context, String metricKey) {
            com.google.common.base.Optional<Measure> files = context.getMeasure(metricKey);
            if (files.isPresent()) {
                return ((Measure)files.get()).getIntValue();
            }
            return 0;
        }
    }
}

