/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.MutableTreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;

public class TreeRootHolderImpl
implements MutableTreeRootHolder {
    @CheckForNull
    private Map<Integer, Component> componentsByRef;
    private Component root;

    @Override
    public MutableTreeRootHolder setRoot(Component root) {
        Preconditions.checkState((this.root == null ? 1 : 0) != 0, (Object)"root can not be set twice in holder");
        this.root = Objects.requireNonNull(root, "root can not be null");
        return this;
    }

    @Override
    public Component getRoot() {
        this.checkInitialized();
        return this.root;
    }

    @Override
    public Component getComponentByRef(int ref) {
        this.checkInitialized();
        this.ensureComponentByRefIsPopulated();
        Component component = this.componentsByRef.get(ref);
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (String)"Component with ref '%s' can't be found", (Object[])new Object[]{ref});
        return component;
    }

    @Override
    public int getSize() {
        this.checkInitialized();
        this.ensureComponentByRefIsPopulated();
        return this.componentsByRef.size();
    }

    private void ensureComponentByRefIsPopulated() {
        if (this.componentsByRef != null) {
            return;
        }
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitAny(Component component) {
                builder.put((Object)component.getReportAttributes().getRef(), (Object)component);
            }
        }).visit(this.root);
        this.componentsByRef = builder.build();
    }

    private void checkInitialized() {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"Holder has not been initialized yet");
    }
}

