/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.KeyWithUuidDto;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;

public class ShortBranchComponentsWithIssues {
    private final String uuid;
    private final DbClient dbClient;
    private Map<String, Set<String>> uuidsByKey;

    public ShortBranchComponentsWithIssues(TreeRootHolder treeRootHolder, DbClient dbClient) {
        this.uuid = treeRootHolder.getRoot().getUuid();
        this.dbClient = dbClient;
    }

    private void loadUuidsByKey() {
        this.uuidsByKey = new HashMap<String, Set<String>>();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List components = this.dbClient.componentDao().selectComponentKeysHavingIssuesToMerge(dbSession, this.uuid);
            for (KeyWithUuidDto dto : components) {
                this.uuidsByKey.computeIfAbsent(ComponentDto.removeBranchFromKey((String)dto.key()), s -> new HashSet()).add(dto.uuid());
            }
        }
    }

    public Set<String> getUuids(String componentKey) {
        if (this.uuidsByKey == null) {
            this.loadUuidsByKey();
        }
        return this.uuidsByKey.getOrDefault(componentKey, Collections.emptySet());
    }
}

