/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.dbcleaner;

import java.util.Collection;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.TimeUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbSession;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.PurgeConfiguration;
import org.sonar.db.purge.PurgeDao;
import org.sonar.db.purge.PurgeListener;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.db.purge.period.DefaultPeriodCleaner;

@ServerSide
@ComputeEngineSide
public class ProjectCleaner {
    private static final Logger LOG = Loggers.get(ProjectCleaner.class);
    private final PurgeProfiler profiler;
    private final PurgeListener purgeListener;
    private final PurgeDao purgeDao;
    private final DefaultPeriodCleaner periodCleaner;

    public ProjectCleaner(PurgeDao purgeDao, DefaultPeriodCleaner periodCleaner, PurgeProfiler profiler, PurgeListener purgeListener) {
        this.purgeDao = purgeDao;
        this.periodCleaner = periodCleaner;
        this.profiler = profiler;
        this.purgeListener = purgeListener;
    }

    public ProjectCleaner purge(DbSession session, IdUuidPair idUuidPair, Configuration projectConfig, Collection<String> disabledComponentUuids) {
        long start = System.currentTimeMillis();
        this.profiler.reset();
        PurgeConfiguration configuration = PurgeConfiguration.newDefaultPurgeConfiguration((Configuration)projectConfig, (IdUuidPair)idUuidPair, disabledComponentUuids);
        this.periodCleaner.clean(session, configuration.rootProjectIdUuid().getUuid(), projectConfig);
        this.purgeDao.purge(session, configuration, this.purgeListener, this.profiler);
        session.commit();
        this.logProfiling(start, projectConfig);
        return this;
    }

    private void logProfiling(long start, Configuration config) {
        if (config.getBoolean("sonar.showProfiling").orElse(false).booleanValue()) {
            long duration = System.currentTimeMillis() - start;
            LOG.info("\n -------- Profiling for purge: " + TimeUtils.formatDuration((long)duration) + " --------\n");
            this.profiler.dump(duration, LOG);
            LOG.info("\n -------- End of profiling for purge --------\n");
        }
    }
}

