/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ws.ComponentDtoToWsComponent;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsComponents;
import org.sonarqube.ws.client.component.ShowWsRequest;

public class ShowAction
implements ComponentsWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public ShowAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("show").setDescription(String.format("Returns a component (file, directory, project, view\u2026) and its ancestors. The ancestors are ordered from the parent to the root project. The '%s' or '%s' parameter must be provided.<br>Requires the following permission: 'Browse' on the project of the specified component.", "componentId", "component")).setResponseExample(this.getClass().getResource("show-example.json")).setSince("5.4").setChangelog(new Change[]{new Change("6.4", "Analysis date has been added to the response"), new Change("6.4", "The field 'id' is deprecated in the response"), new Change("6.4", "The 'visibility' field is added to the response"), new Change("6.5", "Leak period date is added to the response"), new Change("6.6", "'branch' is added to the response"), new Change("6.6", "'version' is added to the response")}).setHandler((RequestHandler)this);
        action.createParam("componentId").setDescription("Component id").setDeprecatedKey("id", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("component").setDescription("Component key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
    }

    public void handle(Request request, Response response) throws Exception {
        ShowWsRequest showWsRequest = ShowAction.toShowWsRequest(request);
        WsComponents.ShowWsResponse showWsResponse = this.doHandle(showWsRequest);
        WsUtils.writeProtobuf((Message)showWsResponse, request, response);
    }

    private WsComponents.ShowWsResponse doHandle(ShowWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            Optional lastAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByComponentUuid(dbSession, component.projectUuid());
            List ancestors = this.dbClient.componentDao().selectAncestors(dbSession, component);
            OrganizationDto organizationDto = this.componentFinder.getOrganization(dbSession, component);
            WsComponents.ShowWsResponse showWsResponse = ShowAction.buildResponse(component, organizationDto, ancestors, lastAnalysis);
            return showWsResponse;
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, ShowWsRequest request) {
        String componentId = request.getId();
        String componentKey = request.getKey();
        String branch = request.getBranch();
        Preconditions.checkArgument((componentId == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{"componentId", "branch"});
        ComponentDto component = branch == null ? this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT) : this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
        this.userSession.checkComponentPermission("user", component);
        return component;
    }

    private static WsComponents.ShowWsResponse buildResponse(ComponentDto component, OrganizationDto organizationDto, List<ComponentDto> orderedAncestors, Optional<SnapshotDto> lastAnalysis) {
        WsComponents.ShowWsResponse.Builder response = WsComponents.ShowWsResponse.newBuilder();
        response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, organizationDto, lastAnalysis));
        int size = orderedAncestors.size() - 1;
        IntStream.rangeClosed(0, size).forEach(index -> response.addAncestors(ComponentDtoToWsComponent.componentDtoToWsComponent((ComponentDto)orderedAncestors.get(size - index), organizationDto, lastAnalysis)));
        return response.build();
    }

    private static ShowWsRequest toShowWsRequest(Request request) {
        return new ShowWsRequest().setId(request.param("componentId")).setKey(request.param("component")).setBranch(request.param("branch"));
    }
}

