/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;

@ServerSide
public class ComponentCleanerService {
    private final DbClient dbClient;
    private final ResourceTypes resourceTypes;
    private final ProjectIndexers projectIndexers;

    public ComponentCleanerService(DbClient dbClient, ResourceTypes resourceTypes, ProjectIndexers projectIndexers) {
        this.dbClient = dbClient;
        this.resourceTypes = resourceTypes;
        this.projectIndexers = projectIndexers;
    }

    public void delete(DbSession dbSession, List<ComponentDto> projects) {
        for (ComponentDto project : projects) {
            this.delete(dbSession, project);
        }
    }

    public void deleteBranch(DbSession dbSession, ComponentDto branch) {
        this.dbClient.purgeDao().deleteBranch(dbSession, branch.uuid());
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(branch), ProjectIndexer.Cause.PROJECT_DELETION);
    }

    public void delete(DbSession dbSession, ComponentDto project) {
        Preconditions.checkArgument((!ComponentCleanerService.hasNotProjectScope(project) && !this.isNotDeletable(project) && project.getMainBranchProjectUuid() == null ? 1 : 0) != 0, (Object)"Only projects can be deleted");
        this.dbClient.purgeDao().deleteProject(dbSession, project.uuid());
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(project), ProjectIndexer.Cause.PROJECT_DELETION);
    }

    private static boolean hasNotProjectScope(ComponentDto project) {
        return !"PRJ".equals(project.scope());
    }

    private boolean isNotDeletable(ComponentDto project) {
        ResourceType resourceType = this.resourceTypes.get(project.qualifier());
        return resourceType == null || !resourceType.getBooleanProperty("deletable");
    }
}

