/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.ws;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.ws.AuthenticationWsAction;
import org.sonar.server.ws.ServletFilterHandler;
import org.sonarqube.ws.client.WsRequest;

public class LogoutAction
extends ServletFilter
implements AuthenticationWsAction {
    private static final String LOGOUT_ACTION = "logout";
    public static final String LOGOUT_URL = "/api/authentication/logout";
    private final JwtHttpHandler jwtHttpHandler;
    private final AuthenticationEvent authenticationEvent;

    public LogoutAction(JwtHttpHandler jwtHttpHandler, AuthenticationEvent authenticationEvent) {
        this.jwtHttpHandler = jwtHttpHandler;
        this.authenticationEvent = authenticationEvent;
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction(LOGOUT_ACTION).setDescription("Logout a user.").setSince("6.3").setPost(true).setHandler(ServletFilterHandler.INSTANCE);
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)LOGOUT_URL);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!request.getMethod().equals(WsRequest.Method.POST.name())) {
            response.setStatus(400);
            return;
        }
        this.logout(request, response);
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) {
        this.generateAuthenticationEvent(request, response);
        this.jwtHttpHandler.removeToken(request, response);
    }

    private void generateAuthenticationEvent(HttpServletRequest request, HttpServletResponse response) {
        try {
            Optional<JwtHttpHandler.Token> token = this.jwtHttpHandler.getToken(request, response);
            String userLogin = token.isPresent() ? token.get().getUserDto().getLogin() : null;
            this.authenticationEvent.logoutSuccess(request, userLogin);
        }
        catch (AuthenticationException e) {
            this.authenticationEvent.logoutFailure(request, e.getMessage());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

