/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.server.webhook.Analysis;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.CeTask;
import org.sonar.server.webhook.Project;
import org.sonar.server.webhook.QualityGate;

public class ProjectAnalysis {
    private final Project project;
    private final CeTask ceTask;
    private final Branch branch;
    private final QualityGate qualityGate;
    private final Long updatedAt;
    private final Map<String, String> properties;
    private final Analysis analysis;

    public ProjectAnalysis(Project project, @Nullable CeTask ceTask, @Nullable Analysis analysis, @Nullable Branch branch, @Nullable QualityGate qualityGate, @Nullable Long updatedAt, Map<String, String> properties) {
        this.project = Objects.requireNonNull(project, "project can't be null");
        this.ceTask = ceTask;
        this.branch = branch;
        this.qualityGate = qualityGate;
        this.updatedAt = updatedAt;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties can't be null"));
        this.analysis = analysis;
    }

    public Optional<CeTask> getCeTask() {
        return Optional.ofNullable(this.ceTask);
    }

    public Project getProject() {
        return this.project;
    }

    public Optional<Branch> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    public Optional<QualityGate> getQualityGate() {
        return Optional.ofNullable(this.qualityGate);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Optional<Analysis> getAnalysis() {
        return Optional.ofNullable(this.analysis);
    }

    public Optional<Long> getUpdatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAnalysis that = (ProjectAnalysis)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.ceTask, that.ceTask) && Objects.equals(this.branch, that.branch) && Objects.equals(this.qualityGate, that.qualityGate) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.properties, that.properties) && Objects.equals(this.analysis, that.analysis);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.ceTask, this.branch, this.qualityGate, this.updatedAt, this.properties, this.analysis);
    }

    public String toString() {
        return "ProjectAnalysis{project=" + this.project + ", ceTask=" + this.ceTask + ", branch=" + this.branch + ", qualityGate=" + this.qualityGate + ", updatedAt=" + this.updatedAt + ", properties=" + this.properties + ", analysis=" + this.analysis + '}';
    }
}

