/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.JsonWriterUtils;

public class UserJsonWriter {
    static final String FIELD_LOGIN = "login";
    static final String FIELD_NAME = "name";
    static final String FIELD_EMAIL = "email";
    static final String FIELD_AVATAR = "avatart";
    static final String FIELD_SCM_ACCOUNTS = "scmAccounts";
    static final String FIELD_GROUPS = "groups";
    static final String FIELD_ACTIVE = "active";
    static final String FIELD_TOKENS_COUNT = "tokensCount";
    static final String FIELD_LOCAL = "local";
    static final String FIELD_EXTERNAL_IDENTITY = "externalIdentity";
    static final String FIELD_EXTERNAL_PROVIDER = "externalProvider";
    public static final Set<String> FIELDS = ImmutableSet.of((Object)"name", (Object)"email", (Object)"avatart", (Object)"scmAccounts", (Object)"groups", (Object)"active", (Object[])new String[]{"local", "externalIdentity", "externalProvider"});
    private static final Set<String> CONCISE_FIELDS = ImmutableSet.of((Object)"name", (Object)"email", (Object)"active");
    private final UserSession userSession;

    public UserJsonWriter(UserSession userSession) {
        this.userSession = userSession;
    }

    public void write(JsonWriter json, UserDto user, Collection<String> groups, @Nullable Collection<String> fields) {
        json.beginObject();
        json.prop(FIELD_LOGIN, user.getLogin());
        JsonWriterUtils.writeIfNeeded(json, user.getName(), FIELD_NAME, fields);
        if (this.userSession.isLoggedIn()) {
            JsonWriterUtils.writeIfNeeded(json, user.getEmail(), FIELD_EMAIL, fields);
            JsonWriterUtils.writeIfNeeded(json, user.isActive(), FIELD_ACTIVE, fields);
            JsonWriterUtils.writeIfNeeded(json, user.isLocal(), FIELD_LOCAL, fields);
            JsonWriterUtils.writeIfNeeded(json, user.getExternalIdentity(), FIELD_EXTERNAL_IDENTITY, fields);
            JsonWriterUtils.writeIfNeeded(json, user.getExternalIdentityProvider(), FIELD_EXTERNAL_PROVIDER, fields);
            this.writeGroupsIfNeeded(json, groups, fields);
            UserJsonWriter.writeScmAccountsIfNeeded(json, fields, user);
        }
        json.endObject();
    }

    public void write(JsonWriter json, @Nullable UserDto user) {
        if (user == null) {
            json.beginObject().endObject();
        } else {
            this.write(json, user, Collections.emptySet(), CONCISE_FIELDS);
        }
    }

    private void writeGroupsIfNeeded(JsonWriter json, Collection<String> groups, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(FIELD_GROUPS, fields) && this.userSession.isSystemAdministrator()) {
            json.name(FIELD_GROUPS).beginArray();
            for (String groupName : groups) {
                json.value(groupName);
            }
            json.endArray();
        }
    }

    private static void writeScmAccountsIfNeeded(JsonWriter json, Collection<String> fields, UserDto user) {
        if (JsonWriterUtils.isFieldNeeded(FIELD_SCM_ACCOUNTS, fields)) {
            json.name(FIELD_SCM_ACCOUNTS).beginArray().values((Iterable)user.getScmAccountsAsList()).endArray();
        }
    }
}

