/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.text;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ServerSide;
import org.sonar.server.text.Macro;
import org.sonar.server.text.RuleMacro;

@ServerSide
public class MacroInterpreter {
    private final List<Macro> macros;

    public MacroInterpreter(Server server) {
        this.macros = ImmutableList.of((Object)new RuleMacro(server.getContextPath()));
    }

    public String interpret(String text) {
        String textReplaced = text;
        for (Macro macro : this.macros) {
            textReplaced = textReplaced.replaceAll(macro.getRegex(), macro.getReplacement());
        }
        return textReplaced;
    }
}

