/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.index;

import com.google.common.collect.ImmutableMap;
import org.sonar.api.config.Configuration;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class TestIndexDefinition
implements IndexDefinition {
    public static final IndexType INDEX_TYPE_TEST = new IndexType("tests", "test");
    public static final String FIELD_PROJECT_UUID = "projectUuid";
    public static final String FIELD_FILE_UUID = "fileUuid";
    public static final String FIELD_TEST_UUID = "testUuid";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_DURATION_IN_MS = "durationInMs";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_STACKTRACE = "stacktrace";
    public static final String FIELD_COVERED_FILES = "coveredFiles";
    public static final String FIELD_COVERED_FILE_UUID = "sourceFileUuid";
    public static final String FIELD_COVERED_FILE_LINES = "coveredLines";
    public static final String FIELD_UPDATED_AT = "updatedAt";
    private final Configuration config;

    public TestIndexDefinition(Configuration config) {
        this.config = config;
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_TEST.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build());
        NewIndex.NewIndexType mapping = index.createType(INDEX_TYPE_TEST.getType());
        mapping.setAttribute("_routing", ImmutableMap.of((Object)"required", (Object)true));
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_PROJECT_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_FILE_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_TEST_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_NAME).disableNorms()).disableSearch()).disableSortingAndAggregating().build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_STATUS).disableNorms()).disableSearch()).build();
        mapping.createLongField(FIELD_DURATION_IN_MS);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_MESSAGE).disableNorms()).disableSearch()).disableSortingAndAggregating().build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_STACKTRACE).disableNorms()).disableSearch()).disableSortingAndAggregating().build();
        mapping.setProperty(FIELD_COVERED_FILES, ImmutableMap.of((Object)"type", (Object)"nested", (Object)"properties", (Object)ImmutableMap.of((Object)FIELD_COVERED_FILE_UUID, (Object)ImmutableMap.of((Object)"type", (Object)"keyword", (Object)"index", (Object)"true"), (Object)FIELD_COVERED_FILE_LINES, (Object)ImmutableMap.of((Object)"type", (Object)"integer"))));
        mapping.createDateTimeField(FIELD_UPDATED_AT);
    }
}

