/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.Startable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.RemotePlugin;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.plugin.PluginDto;
import org.sonar.server.plugins.ServerPluginRepository;

public class RegisterPlugins
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterPlugins.class);
    private final ServerPluginRepository repository;
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final System2 system;

    public RegisterPlugins(ServerPluginRepository repository, DbClient dbClient, UuidFactory uuidFactory, System2 system) {
        this.repository = repository;
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.system = system;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Register plugins");
        this.updateDB(this.repository.getPluginInfos());
        profiler.stopDebug();
    }

    public void stop() {
    }

    private void updateDB(Collection<PluginInfo> pluginInfos) {
        long now = this.system.now();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map allPreviousPluginsByKey = this.dbClient.pluginDao().selectAll(dbSession).stream().collect(Collectors.toMap(PluginDto::getKee, Function.identity()));
            for (PluginInfo pluginInfo : pluginInfos) {
                RemotePlugin remotePlugin = RemotePlugin.create((PluginInfo)pluginInfo);
                String newJarMd5 = remotePlugin.file().getHash();
                PluginDto previousDto = (PluginDto)allPreviousPluginsByKey.get(pluginInfo.getKey());
                if (previousDto == null) {
                    LOG.debug("Register new plugin {}", (Object)pluginInfo.getKey());
                    PluginDto pluginDto = new PluginDto().setUuid(this.uuidFactory.create()).setKee(pluginInfo.getKey()).setBasePluginKey(pluginInfo.getBasePlugin()).setFileHash(newJarMd5).setCreatedAt(now).setUpdatedAt(now);
                    this.dbClient.pluginDao().insert(dbSession, pluginDto);
                    continue;
                }
                if (previousDto.getFileHash().equals(newJarMd5)) continue;
                LOG.debug("Update plugin {}", (Object)pluginInfo.getKey());
                previousDto.setBasePluginKey(pluginInfo.getBasePlugin()).setFileHash(newJarMd5).setUpdatedAt(now);
                this.dbClient.pluginDao().update(dbSession, previousDto);
            }
            dbSession.commit();
        }
    }
}

