/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.platform.RemotePlugin;
import org.sonar.server.platform.ServerFileSystem;

@ServerSide
public final class GeneratePluginIndex
implements Startable {
    private static final Logger LOG = Loggers.get(GeneratePluginIndex.class);
    private final ServerFileSystem fileSystem;
    private final PluginRepository repository;

    public GeneratePluginIndex(ServerFileSystem fileSystem, PluginRepository repository) {
        this.fileSystem = fileSystem;
        this.repository = repository;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Generate scanner plugin index");
        this.writeIndex(this.fileSystem.getPluginIndex());
        profiler.stopDebug();
    }

    public void stop() {
    }

    void writeIndex(File indexFile) {
        try {
            FileUtils.forceMkdir((File)indexFile.getParentFile());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), StandardCharsets.UTF_8);){
                for (PluginInfo pluginInfo : this.repository.getPluginInfos()) {
                    ((Writer)writer).append(RemotePlugin.create((PluginInfo)pluginInfo).marshal());
                    writer.append('\n');
                }
                ((Writer)writer).flush();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to generate plugin index at " + indexFile, e);
        }
    }
}

