/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.util.Date;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.HtmlSourceDecorator;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class LinesAction
implements SourcesWsAction {
    private static final String PARAM_UUID = "uuid";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_FROM = "from";
    private static final String PARAM_TO = "to";
    private static final String PARAM_BRANCH = "branch";
    private final ComponentFinder componentFinder;
    private final SourceService sourceService;
    private final HtmlSourceDecorator htmlSourceDecorator;
    private final DbClient dbClient;
    private final UserSession userSession;

    public LinesAction(ComponentFinder componentFinder, DbClient dbClient, SourceService sourceService, HtmlSourceDecorator htmlSourceDecorator, UserSession userSession) {
        this.componentFinder = componentFinder;
        this.sourceService = sourceService;
        this.htmlSourceDecorator = htmlSourceDecorator;
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("lines").setDescription("Show source code with line oriented info. Require See Source Code permission on file's project<br/>Each element of the result array is an object which contains:<ol><li>Line number</li><li>Content of the line</li><li>Author of the line (from SCM information)</li><li>Revision of the line (from SCM information)</li><li>Last commit date of the line (from SCM information)</li><li>Line hits from coverage</li><li>Number of conditions to cover in tests</li><li>Number of conditions covered by tests</li></ol>").setSince("5.0").setInternal(true).setResponseExample(Resources.getResource(this.getClass(), (String)"lines-example.json")).setChangelog(new Change[]{new Change("6.2", "fields \"utLineHits\", \"utConditions\" and \"utCoveredConditions\" has been renamed \"lineHits\", \"conditions\" and \"coveredConditions\""), new Change("6.2", "fields \"itLineHits\", \"itConditions\" and \"itCoveredConditions\" are no more returned"), new Change("6.6", "fields \"branch\" added")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_UUID).setDescription("File uuid. Mandatory if param 'key' is not set").setExampleValue((Object)"f333aab4-7e3a-4d70-87e1-f4c491f05e5c");
        action.createParam(PARAM_KEY).setDescription("File key. Mandatory if param 'uuid' is not set. Available since 5.2").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam(PARAM_BRANCH).setDescription("Branch key").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_FROM).setDescription("First line to return. Starts from 1").setExampleValue((Object)"10").setDefaultValue((Object)"1");
        action.createParam(PARAM_TO).setDescription("Optional last line to return (inclusive). It must be greater than or equal to parameter 'from'. If unset, then all the lines greater than or equal to 'from' are returned.").setExampleValue((Object)"20");
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto file = this.loadComponent(dbSession, request);
            this.userSession.checkComponentPermission("codeviewer", file);
            int from = request.mandatoryParamAsInt(PARAM_FROM);
            int to = (Integer)MoreObjects.firstNonNull((Object)request.paramAsInt(PARAM_TO), (Object)Integer.MAX_VALUE);
            Iterable<DbFileSources.Line> lines = WsUtils.checkFoundWithOptional(this.sourceService.getLines(dbSession, file.uuid(), from, to), "No source found for file '%s'", file.getDbKey());
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                this.writeSource(lines, json);
                json.endObject();
            }
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request wsRequest) {
        String componentKey = wsRequest.param(PARAM_KEY);
        String componentId = wsRequest.param(PARAM_UUID);
        String branch = wsRequest.param(PARAM_BRANCH);
        Preconditions.checkArgument((componentId == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{PARAM_UUID, PARAM_BRANCH});
        return branch == null ? this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.UUID_AND_KEY) : this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
    }

    private void writeSource(Iterable<DbFileSources.Line> lines, JsonWriter json) {
        json.name("sources").beginArray();
        for (DbFileSources.Line line : lines) {
            Optional<Integer> coveredConditions;
            Optional<Integer> conditions;
            Optional<Integer> lineHits;
            json.beginObject().prop("line", (long)line.getLine()).prop("code", this.htmlSourceDecorator.getDecoratedSourceAsHtml(line.getSource(), line.getHighlighting(), line.getSymbols())).prop("scmAuthor", line.getScmAuthor()).prop("scmRevision", line.getScmRevision());
            if (line.hasScmDate()) {
                json.prop("scmDate", DateUtils.formatDateTime((Date)new Date(line.getScmDate())));
            }
            if ((lineHits = LinesAction.getLineHits(line)).isPresent()) {
                json.prop("utLineHits", (Number)lineHits.get());
                json.prop("lineHits", (Number)lineHits.get());
            }
            if ((conditions = LinesAction.getConditions(line)).isPresent()) {
                json.prop("utConditions", (Number)conditions.get());
                json.prop("conditions", (Number)conditions.get());
            }
            if ((coveredConditions = LinesAction.getCoveredConditions(line)).isPresent()) {
                json.prop("utCoveredConditions", (Number)coveredConditions.get());
                json.prop("coveredConditions", (Number)coveredConditions.get());
            }
            json.prop("duplicated", line.getDuplicationCount() > 0);
            json.endObject();
        }
        json.endArray();
    }

    private static Optional<Integer> getLineHits(DbFileSources.Line line) {
        if (line.hasLineHits()) {
            return Optional.of(line.getLineHits());
        }
        if (line.hasDeprecatedOverallLineHits()) {
            return Optional.of(line.getDeprecatedOverallLineHits());
        }
        if (line.hasDeprecatedUtLineHits()) {
            return Optional.of(line.getDeprecatedUtLineHits());
        }
        if (line.hasDeprecatedItLineHits()) {
            return Optional.of(line.getDeprecatedItLineHits());
        }
        return Optional.empty();
    }

    private static Optional<Integer> getConditions(DbFileSources.Line line) {
        if (line.hasConditions()) {
            return Optional.of(line.getConditions());
        }
        if (line.hasDeprecatedOverallConditions()) {
            return Optional.of(line.getDeprecatedOverallConditions());
        }
        if (line.hasDeprecatedUtConditions()) {
            return Optional.of(line.getDeprecatedUtConditions());
        }
        if (line.hasDeprecatedItConditions()) {
            return Optional.of(line.getDeprecatedItConditions());
        }
        return Optional.empty();
    }

    private static Optional<Integer> getCoveredConditions(DbFileSources.Line line) {
        if (line.hasCoveredConditions()) {
            return Optional.of(line.getCoveredConditions());
        }
        if (line.hasDeprecatedOverallCoveredConditions()) {
            return Optional.of(line.getDeprecatedOverallCoveredConditions());
        }
        if (line.hasDeprecatedUtCoveredConditions()) {
            return Optional.of(line.getDeprecatedUtCoveredConditions());
        }
        if (line.hasDeprecatedItCoveredConditions()) {
            return Optional.of(line.getDeprecatedItCoveredConditions());
        }
        return Optional.empty();
    }
}

