/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.protobuf.Message;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Settings;

public class GenerateSecretKeyAction
implements SettingsWsAction {
    private final Settings settings;
    private final UserSession userSession;

    public GenerateSecretKeyAction(Settings settings, UserSession userSession) {
        this.settings = settings;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        context.createAction("generate_secret_key").setDescription("Generate a secret key.<br>Requires the 'Administer System' permission").setSince("6.1").setInternal(true).setResponseExample(this.getClass().getResource("generate_secret_key-example.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        WsUtils.writeProtobuf((Message)Settings.GenerateSecretKeyWsResponse.newBuilder().setSecretKey(this.settings.getEncryption().generateRandomSecretKey()).build(), request, response);
    }
}

