/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.db.DbClient;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.rule.CachingRuleFinder;
import org.sonar.server.rule.DefaultRuleFinder;
import org.sonar.server.rule.WebServerRuleFinder;

public class WebServerRuleFinderImpl
implements WebServerRuleFinder {
    private final DbClient dbClient;
    private final RuleFinder defaultFinder;
    @VisibleForTesting
    RuleFinder delegate;

    public WebServerRuleFinderImpl(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.delegate = this.defaultFinder = new DefaultRuleFinder(dbClient, defaultOrganizationProvider);
    }

    @Override
    public void startCaching() {
        this.delegate = new CachingRuleFinder(this.dbClient);
    }

    @Override
    public void stopCaching() {
        this.delegate = this.defaultFinder;
    }

    @CheckForNull
    @Deprecated
    public Rule findById(int ruleId) {
        return this.delegate.findById(ruleId);
    }

    @CheckForNull
    public Rule findByKey(String repositoryKey, String key) {
        return this.delegate.findByKey(repositoryKey, key);
    }

    @CheckForNull
    public Rule findByKey(RuleKey key) {
        return this.delegate.findByKey(key);
    }

    @CheckForNull
    public Rule find(RuleQuery query) {
        return this.delegate.find(query);
    }

    public Collection<Rule> findAll(RuleQuery query) {
        return this.delegate.findAll(query);
    }
}

