/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.GroupMembershipDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.SearchGroupsQuery;
import org.sonar.db.user.GroupDto;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.QualityProfiles;
import org.sonarqube.ws.client.qualityprofile.SearchUsersRequest;

public class SearchGroupsAction
implements QProfileWsAction {
    private static final Map<WebService.SelectionMode, String> MEMBERSHIP = ImmutableMap.of((Object)WebService.SelectionMode.SELECTED, (Object)"IN", (Object)WebService.SelectionMode.DESELECTED, (Object)"OUT", (Object)WebService.SelectionMode.ALL, (Object)"ANY");
    private final DbClient dbClient;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;

    public SearchGroupsAction(DbClient dbClient, QProfileWsSupport wsSupport, Languages languages) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.languages = languages;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_groups").setDescription("List the groups that are allowed to edit a Quality Profile.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setInternal(true).addSelectionModeParam().addSearchQuery("sonar", new String[]{"group names"}).addPagingParams(25).setResponseExample(this.getClass().getResource("search_groups-example.json")).setSince("6.6");
        action.createParam("qualityProfile").setDescription("Quality Profile name").setRequired(true).setExampleValue((Object)"Recommended quality profile");
        action.createParam("language").setDescription("Quality profile language").setRequired(true).setPossibleValues((Collection)Arrays.stream(this.languages.all()).map(Language::getKey).collect(MoreCollectors.toSet()));
        QProfileWsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        SearchUsersRequest wsRequest = SearchGroupsAction.buildRequest(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, wsRequest.getOrganization());
            QProfileDto profile = this.wsSupport.getProfile(dbSession, organization, wsRequest.getQualityProfile(), wsRequest.getLanguage());
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            SearchGroupsQuery query = SearchGroupsQuery.builder().setOrganization(organization).setProfile(profile).setQuery(wsRequest.getQuery()).setMembership(MEMBERSHIP.get(WebService.SelectionMode.fromParam((String)wsRequest.getSelected()))).build();
            int total = this.dbClient.qProfileEditGroupsDao().countByQuery(dbSession, query);
            List groupMemberships = this.dbClient.qProfileEditGroupsDao().selectByQuery(dbSession, query, Pagination.forPage((int)wsRequest.getPage()).andSize(wsRequest.getPageSize().intValue()));
            Map groupsById = (Map)this.dbClient.groupDao().selectByIds(dbSession, (List)groupMemberships.stream().map(GroupMembershipDto::getGroupId).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(GroupDto::getId));
            WsUtils.writeProtobuf((Message)QualityProfiles.SearchGroupsResponse.newBuilder().addAllGroups((Iterable)groupMemberships.stream().map(groupsMembership -> SearchGroupsAction.toGroup((GroupDto)groupsById.get(groupsMembership.getGroupId()), groupsMembership.isSelected())).collect(MoreCollectors.toList())).setPaging(SearchGroupsAction.buildPaging(wsRequest, total)).build(), request, response);
        }
    }

    private static SearchUsersRequest buildRequest(Request request) {
        return SearchUsersRequest.builder().setOrganization(request.param("organization")).setQualityProfile(request.mandatoryParam("qualityProfile")).setLanguage(request.mandatoryParam("language")).setQuery(request.param("q")).setSelected(request.mandatoryParam("selected")).setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).build();
    }

    private static QualityProfiles.SearchGroupsResponse.Group toGroup(GroupDto group, boolean isSelected) {
        QualityProfiles.SearchGroupsResponse.Group.Builder builder = QualityProfiles.SearchGroupsResponse.Group.newBuilder().setName(group.getName()).setSelected(isSelected);
        Protobuf.setNullable((Object)group.getDescription(), arg_0 -> ((QualityProfiles.SearchGroupsResponse.Group.Builder)builder).setDescription(arg_0));
        return builder.build();
    }

    private static Common.Paging buildPaging(SearchUsersRequest wsRequest, int total) {
        return Common.Paging.newBuilder().setPageIndex(wsRequest.getPage().intValue()).setPageSize(wsRequest.getPageSize().intValue()).setTotal(total).build();
    }
}

