/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class RemoveUserAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;

    public RemoveUserAction(DbClient dbClient, QProfileWsSupport wsSupport, Languages languages) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.languages = languages;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_user").setDescription("Remove the ability from a user to edit a Quality Profile.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setPost(true).setInternal(true).setSince("6.6");
        action.createParam("qualityProfile").setDescription("Quality Profile name").setRequired(true).setExampleValue((Object)"Recommended quality profile");
        action.createParam("language").setDescription("Quality profile language").setRequired(true).setPossibleValues((Collection)Arrays.stream(this.languages.all()).map(Language::getKey).collect(MoreCollectors.toSet()));
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"john.doe");
        QProfileWsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, request.param("organization"));
            QProfileDto profile = this.wsSupport.getProfile(dbSession, organization, request.mandatoryParam("qualityProfile"), request.mandatoryParam("language"));
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            UserDto user = this.wsSupport.getUser(dbSession, organization, request.mandatoryParam("login"));
            this.removeUser(dbSession, profile, user);
        }
        response.noContent();
    }

    private void removeUser(DbSession dbSession, QProfileDto profile, UserDto user) {
        if (!this.dbClient.qProfileEditUsersDao().exists(dbSession, profile, user)) {
            return;
        }
        this.dbClient.qProfileEditUsersDao().deleteByQProfileAndUser(dbSession, profile, user);
        dbSession.commit();
    }
}

