/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;

public class RemoveProjectAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final Languages languages;
    private final ComponentFinder componentFinder;
    private final QProfileWsSupport wsSupport;

    public RemoveProjectAction(DbClient dbClient, UserSession userSession, Languages languages, ComponentFinder componentFinder, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.languages = languages;
        this.componentFinder = componentFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("remove_project").setSince("5.2").setDescription("Remove a project's association with a quality profile.<br> Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li>  <li>Administer right on the specified project</li></ul>").setPost(true).setHandler((RequestHandler)this);
        QProfileReference.defineParams(action, this.languages);
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
        action.createParam("project").setDescription("Project key").setDeprecatedKey("projectKey", "6.5").setExampleValue((Object)"my_project");
        action.createParam("projectUuid").setDescription("Project ID. Either this parameter, or '%s' must be set.", new Object[]{"project"}).setDeprecatedSince("6.5").setExampleValue((Object)"AU-TpxcB-iU5OvuD2FL6");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.loadProject(dbSession, request);
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.from(request));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.checkPermissions(dbSession, organization, profile, project);
            if (!profile.getOrganizationUuid().equals(project.getOrganizationUuid())) {
                throw new IllegalArgumentException("Project and Quality profile must have the same organization");
            }
            this.dbClient.qualityProfileDao().deleteProjectProfileAssociation(dbSession, project, profile);
            dbSession.commit();
            response.noContent();
        }
    }

    private ComponentDto loadProject(DbSession dbSession, Request request) {
        String projectKey = request.param("project");
        String projectUuid = request.param("projectUuid");
        return this.componentFinder.getByUuidOrKey(dbSession, projectUuid, projectKey, ComponentFinder.ParamNames.PROJECT_UUID_AND_PROJECT);
    }

    private void checkPermissions(DbSession dbSession, OrganizationDto organization, QProfileDto profile, ComponentDto project) {
        if (this.wsSupport.canEdit(dbSession, organization, profile) || this.userSession.hasComponentPermission("admin", project)) {
            return;
        }
        throw AbstractUserSession.insufficientPrivilegesException();
    }
}

