/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;

public class ExportersAction
implements QProfileWsAction {
    private ProfileExporter[] exporters;

    public ExportersAction(ProfileExporter[] exporters) {
        this.exporters = exporters;
    }

    public ExportersAction() {
        this(new ProfileExporter[0]);
    }

    public void define(WebService.NewController context) {
        context.createAction("exporters").setDescription("Lists available profile export formats.").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("exporters-example.json")).setSince("5.2");
    }

    public void handle(Request request, Response response) throws Exception {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("exporters").beginArray();
            for (ProfileExporter exporter : this.exporters) {
                json.beginObject().prop("key", exporter.getKey()).prop("name", exporter.getName());
                json.name("languages").beginArray();
                for (String language : exporter.getSupportedLanguages()) {
                    json.value(language);
                }
                json.endArray().endObject();
            }
            json.endArray().endObject();
        }
    }
}

