/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.index;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.qualityprofile.ActiveRule;

public class ActiveRuleDoc
extends BaseDoc {
    public ActiveRuleDoc(long id) {
        super(Maps.newHashMapWithExpectedSize((int)10));
        this.setField("id", String.valueOf(id));
    }

    public ActiveRuleDoc(Map<String, Object> source) {
        super(source);
    }

    @Override
    public String getId() {
        return (String)this.getField("id");
    }

    @Override
    public String getRouting() {
        return this.getRuleKeyAsString();
    }

    @Override
    public String getParent() {
        return this.getRuleKey().toString();
    }

    RuleKey getRuleKey() {
        return RuleKey.parse((String)this.getRuleKeyAsString());
    }

    private String getRuleKeyAsString() {
        return (String)this.getField("ruleKey");
    }

    String getRuleRepository() {
        return (String)this.getField("repo");
    }

    String getSeverity() {
        return (String)this.getNullableField("severity");
    }

    ActiveRuleDoc setSeverity(@Nullable String s) {
        this.setField("severity", s);
        return this;
    }

    ActiveRuleDoc setRuleKey(RuleKey ruleKey) {
        this.setField("ruleKey", ruleKey.toString());
        this.setField("repo", ruleKey.repository());
        return this;
    }

    String getRuleProfileUuid() {
        return (String)this.getField("ruleProfile");
    }

    ActiveRuleDoc setRuleProfileUuid(String s) {
        this.setField("ruleProfile", s);
        return this;
    }

    ActiveRule.Inheritance getInheritance() {
        String inheritance = (String)this.getNullableField("inheritance");
        if (inheritance == null || inheritance.isEmpty() || StringUtils.containsIgnoreCase((String)inheritance, (String)"none")) {
            return ActiveRule.Inheritance.NONE;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"herit")) {
            return ActiveRule.Inheritance.INHERITED;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"over")) {
            return ActiveRule.Inheritance.OVERRIDES;
        }
        throw new IllegalStateException("Value \"" + inheritance + "\" is not valid for rule's inheritance");
    }

    public ActiveRuleDoc setInheritance(@Nullable String s) {
        this.setField("inheritance", s);
        return this;
    }
}

