/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.server.qualityprofile.ActiveRule;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileInsert;
import org.sonar.server.qualityprofile.BuiltInQProfileRepository;
import org.sonar.server.qualityprofile.BuiltInQProfileUpdate;
import org.sonar.server.qualityprofile.BuiltInQualityProfilesUpdateListener;
import org.sonar.server.qualityprofile.QProfileName;

@ServerSide
public class RegisterQualityProfiles {
    private static final Logger LOGGER = Loggers.get(RegisterQualityProfiles.class);
    private final BuiltInQProfileRepository builtInQProfileRepository;
    private final DbClient dbClient;
    private final BuiltInQProfileInsert builtInQProfileInsert;
    private final BuiltInQProfileUpdate builtInQProfileUpdate;
    private final BuiltInQualityProfilesUpdateListener builtInQualityProfilesNotification;
    private final System2 system2;

    public RegisterQualityProfiles(BuiltInQProfileRepository builtInQProfileRepository, DbClient dbClient, BuiltInQProfileInsert builtInQProfileInsert, BuiltInQProfileUpdate builtInQProfileUpdate, BuiltInQualityProfilesUpdateListener builtInQualityProfilesNotification, System2 system2) {
        this.builtInQProfileRepository = builtInQProfileRepository;
        this.dbClient = dbClient;
        this.builtInQProfileInsert = builtInQProfileInsert;
        this.builtInQProfileUpdate = builtInQProfileUpdate;
        this.builtInQualityProfilesNotification = builtInQualityProfilesNotification;
        this.system2 = system2;
    }

    public void start() {
        List<BuiltInQProfile> builtInQProfiles = this.builtInQProfileRepository.get();
        if (builtInQProfiles.isEmpty()) {
            return;
        }
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass())).startInfo("Register quality profiles");
        try (DbSession dbSession = this.dbClient.openSession(false);
             DbSession batchDbSession = this.dbClient.openSession(true);){
            long startDate = this.system2.now();
            Map<QProfileName, RulesProfileDto> persistedRuleProfiles = this.loadPersistedProfiles(dbSession);
            ArrayListMultimap changedProfiles = ArrayListMultimap.create();
            builtInQProfiles.forEach(arg_0 -> this.lambda$start$1(persistedRuleProfiles, dbSession, batchDbSession, (Multimap)changedProfiles, arg_0));
            if (!changedProfiles.isEmpty()) {
                long endDate = this.system2.now();
                this.builtInQualityProfilesNotification.onChange((Multimap<QProfileName, ActiveRuleChange>)changedProfiles, startDate, endDate);
            }
        }
        profiler.stopDebug();
    }

    private Map<QProfileName, RulesProfileDto> loadPersistedProfiles(DbSession dbSession) {
        return (Map)this.dbClient.qualityProfileDao().selectBuiltInRulesProfiles(dbSession).stream().collect(MoreCollectors.uniqueIndex(rp -> new QProfileName(rp.getLanguage(), rp.getName())));
    }

    private void register(DbSession dbSession, DbSession batchDbSession, BuiltInQProfile builtIn) {
        LOGGER.info("Register profile {}", (Object)builtIn.getQProfileName());
        this.renameOutdatedProfiles(dbSession, builtIn);
        this.builtInQProfileInsert.create(dbSession, batchDbSession, builtIn);
    }

    private List<ActiveRuleChange> update(DbSession dbSession, BuiltInQProfile builtIn, RulesProfileDto ruleProfile) {
        LOGGER.info("Update profile {}", (Object)builtIn.getQProfileName());
        return this.builtInQProfileUpdate.update(dbSession, builtIn, ruleProfile);
    }

    private void renameOutdatedProfiles(DbSession dbSession, BuiltInQProfile profile) {
        Collection uuids = this.dbClient.qualityProfileDao().selectUuidsOfCustomRulesProfiles(dbSession, profile.getLanguage(), profile.getName());
        if (uuids.isEmpty()) {
            return;
        }
        Profiler profiler = Profiler.createIfDebug((Logger)Loggers.get(this.getClass())).start();
        String newName = profile.getName() + " (outdated copy)";
        LOGGER.info("Rename Quality profiles [{}/{}] to [{}] in {}\u00a0organizations", new Object[]{profile.getLanguage(), profile.getName(), newName, uuids.size()});
        this.dbClient.qualityProfileDao().renameRulesProfilesAndCommit(dbSession, uuids, newName);
        profiler.stopDebug(String.format("%d Quality profiles renamed to [%s]", uuids.size(), newName));
    }

    private /* synthetic */ void lambda$start$1(Map persistedRuleProfiles, DbSession dbSession, DbSession batchDbSession, Multimap changedProfiles, BuiltInQProfile builtIn) {
        RulesProfileDto ruleProfile = (RulesProfileDto)persistedRuleProfiles.get(builtIn.getQProfileName());
        if (ruleProfile == null) {
            this.register(dbSession, batchDbSession, builtIn);
        } else {
            List<ActiveRuleChange> changes = this.update(dbSession, builtIn, ruleProfile);
            changedProfiles.putAll((Object)builtIn.getQProfileName(), (Iterable)changes.stream().filter(change -> {
                String inheritance = change.getActiveRule().getInheritance();
                return inheritance == null || ActiveRule.Inheritance.NONE.name().equals(inheritance);
            }).collect(MoreCollectors.toList()));
        }
    }
}

