/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileRepository;

public class BuiltInQProfileRepositoryImpl
implements BuiltInQProfileRepository {
    private static final Logger LOGGER = Loggers.get(BuiltInQProfileRepositoryImpl.class);
    private static final String DEFAULT_PROFILE_NAME = "Sonar way";
    private final Languages languages;
    private final List<BuiltInQualityProfilesDefinition> definitions;
    private List<BuiltInQProfile> qProfiles;

    public BuiltInQProfileRepositoryImpl(Languages languages) {
        this(languages, new BuiltInQualityProfilesDefinition[0]);
    }

    public BuiltInQProfileRepositoryImpl(Languages languages, BuiltInQualityProfilesDefinition ... definitions) {
        this.languages = languages;
        this.definitions = ImmutableList.copyOf((Object[])definitions);
    }

    @Override
    public void initialize() {
        Preconditions.checkState((this.qProfiles == null ? 1 : 0) != 0, (Object)"initialize must be called only once");
        Profiler profiler = Profiler.create((Logger)LOGGER).startInfo("Load quality profiles");
        BuiltInQualityProfilesDefinition.Context context = new BuiltInQualityProfilesDefinition.Context();
        for (BuiltInQualityProfilesDefinition definition : this.definitions) {
            definition.define(context);
        }
        Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguage = this.validateAndClean(context);
        this.qProfiles = BuiltInQProfileRepositoryImpl.toFlatList(rulesProfilesByLanguage);
        profiler.stopDebug();
    }

    @Override
    public List<BuiltInQProfile> get() {
        Preconditions.checkState((this.qProfiles != null ? 1 : 0) != 0, (Object)"initialize must be called first");
        return this.qProfiles;
    }

    private Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> validateAndClean(BuiltInQualityProfilesDefinition.Context context) {
        Map profilesByLanguageAndName = context.profilesByLanguageAndName();
        profilesByLanguageAndName.entrySet().removeIf(entry -> {
            String language = (String)entry.getKey();
            if (this.languages.get(language) == null) {
                LOGGER.info("Language {} is not installed, related Quality profiles are ignored", (Object)language);
                return true;
            }
            Collection profiles = ((Map)entry.getValue()).values();
            if (profiles.isEmpty()) {
                LOGGER.warn("No Quality profiles defined for language: {}", (Object)language);
                return true;
            }
            return false;
        });
        return profilesByLanguageAndName;
    }

    private static List<BuiltInQProfile> toFlatList(Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguage) {
        Map buildersByLanguage = (Map)rulesProfilesByLanguage.entrySet().stream().collect(MoreCollectors.uniqueIndex(Map.Entry::getKey, BuiltInQProfileRepositoryImpl::toQualityProfileBuilders));
        return (List)buildersByLanguage.entrySet().stream().filter(BuiltInQProfileRepositoryImpl::ensureAtMostOneDeclaredDefault).map(entry -> BuiltInQProfileRepositoryImpl.toQualityProfiles((List)entry.getValue())).flatMap(Collection::stream).collect(MoreCollectors.toList());
    }

    private static List<BuiltInQProfile.Builder> toQualityProfileBuilders(Map.Entry<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguageAndName) {
        String language = rulesProfilesByLanguageAndName.getKey();
        LinkedHashMap<String, BuiltInQProfile.Builder> qualityProfileBuildersByName = new LinkedHashMap<String, BuiltInQProfile.Builder>();
        for (BuiltInQualityProfilesDefinition.BuiltInQualityProfile builtInProfile : rulesProfilesByLanguageAndName.getValue().values()) {
            qualityProfileBuildersByName.compute(builtInProfile.name(), (name, existingBuilder) -> BuiltInQProfileRepositoryImpl.updateOrCreateBuilder(language, existingBuilder, builtInProfile));
        }
        return ImmutableList.copyOf(qualityProfileBuildersByName.values());
    }

    private static boolean ensureAtMostOneDeclaredDefault(Map.Entry<String, List<BuiltInQProfile.Builder>> entry) {
        Set declaredDefaultProfileNames = (Set)entry.getValue().stream().filter(BuiltInQProfile.Builder::isDeclaredDefault).map(BuiltInQProfile.Builder::getName).collect(MoreCollectors.toSet());
        Preconditions.checkState((declaredDefaultProfileNames.size() <= 1 ? 1 : 0) != 0, (String)"Several Quality profiles are flagged as default for the language %s: %s", (Object[])new Object[]{entry.getKey(), declaredDefaultProfileNames});
        return true;
    }

    private static BuiltInQProfile.Builder updateOrCreateBuilder(String language, @Nullable BuiltInQProfile.Builder existingBuilder, BuiltInQualityProfilesDefinition.BuiltInQualityProfile builtInProfile) {
        BuiltInQProfile.Builder builder = existingBuilder;
        if (builder == null) {
            builder = new BuiltInQProfile.Builder().setLanguage(language).setName(builtInProfile.name());
        }
        return builder.setDeclaredDefault(builtInProfile.isDefault()).addRules(builtInProfile.rules());
    }

    private static List<BuiltInQProfile> toQualityProfiles(List<BuiltInQProfile.Builder> builders) {
        if (builders.stream().noneMatch(BuiltInQProfile.Builder::isDeclaredDefault)) {
            Optional<BuiltInQProfile.Builder> sonarWayProfile = builders.stream().filter(builder -> builder.getName().equals(DEFAULT_PROFILE_NAME)).findFirst();
            if (sonarWayProfile.isPresent()) {
                sonarWayProfile.get().setComputedDefault(true);
            } else {
                builders.iterator().next().setComputedDefault(true);
            }
        }
        return (List)builders.stream().map(BuiltInQProfile.Builder::build).collect(MoreCollectors.toList((int)builders.size()));
    }
}

