/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualitygate.QualityGates;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class DeselectAction
implements QualityGatesWsAction {
    private final QualityGates qualityGates;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public DeselectAction(QualityGates qualityGates, DbClient dbClient, ComponentFinder componentFinder) {
        this.qualityGates = qualityGates;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("deselect").setDescription("Remove the association of a project from a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.6", "The parameter 'gateId' was removed")});
        action.createParam("projectId").setDescription("Project id").setDeprecatedSince("6.1").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project").setSince("6.1");
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.getProject(dbSession, request.param("projectId"), request.param("projectKey"));
            this.qualityGates.dissociateProject(dbSession, project);
            response.noContent();
        }
    }

    private ComponentDto getProject(DbSession dbSession, @Nullable String projectId, @Nullable String projectKey) {
        return (ComponentDto)this.selectProjectById(dbSession, projectId).or(() -> this.componentFinder.getByUuidOrKey(dbSession, projectId, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY));
    }

    private Optional<ComponentDto> selectProjectById(DbSession dbSession, @Nullable String projectId) {
        if (projectId == null) {
            return Optional.absent();
        }
        try {
            long dbId = Long.parseLong(projectId);
            return this.dbClient.componentDao().selectById(dbSession, dbId);
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }
}

