/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.user.UserSession;

public class DeleteConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QualityGatesWsSupport wsSupport;

    public DeleteConditionAction(UserSession userSession, DbClient dbClient, QualityGatesWsSupport wsSupport) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("delete_condition").setDescription("Delete a condition from a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        createCondition.createParam("id").setRequired(true).setDescription("Condition ID").setExampleValue((Object)"2");
    }

    public void handle(Request request, Response response) {
        long conditionId = request.mandatoryParamAsLong("id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organization);
            this.dbClient.gateConditionDao().delete(this.wsSupport.getCondition(dbSession, conditionId), dbSession);
            dbSession.commit();
            response.noContent();
        }
    }
}

