/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsQualityGates;
import org.sonarqube.ws.client.qualitygate.CreateConditionRequest;

public class CreateConditionAction
implements QualityGatesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public CreateConditionAction(UserSession userSession, DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("create_condition").setDescription("Add a new condition to a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        createCondition.createParam("gateId").setDescription("ID of the quality gate").setRequired(true).setExampleValue((Object)"1");
        QualityGatesWs.addConditionParams(createCondition);
    }

    public void handle(Request request, Response response) {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, this.defaultOrganizationProvider.get().getUuid());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            WsUtils.writeProtobuf((Message)this.doHandle(CreateConditionAction.toWsRequest(request), dbSession), request, response);
            dbSession.commit();
        }
    }

    private WsQualityGates.CreateConditionWsResponse doHandle(CreateConditionRequest request, DbSession dbSession) {
        QualityGateConditionDto condition = this.qualityGateConditionsUpdater.createCondition(dbSession, request.getQualityGateId(), request.getMetricKey(), request.getOperator(), request.getWarning(), request.getError(), request.getPeriod());
        WsQualityGates.CreateConditionWsResponse.Builder response = WsQualityGates.CreateConditionWsResponse.newBuilder().setId(condition.getId()).setMetric(condition.getMetricKey()).setOp(condition.getOperator());
        Protobuf.setNullable((Object)condition.getWarningThreshold(), arg_0 -> ((WsQualityGates.CreateConditionWsResponse.Builder)response).setWarning(arg_0));
        Protobuf.setNullable((Object)condition.getErrorThreshold(), arg_0 -> ((WsQualityGates.CreateConditionWsResponse.Builder)response).setError(arg_0));
        Protobuf.setNullable((Object)condition.getPeriod(), arg_0 -> ((WsQualityGates.CreateConditionWsResponse.Builder)response).setPeriod(arg_0));
        return response.build();
    }

    private static CreateConditionRequest toWsRequest(Request request) {
        return CreateConditionRequest.builder().setQualityGateId((long)request.mandatoryParamAsInt("gateId")).setMetricKey(request.mandatoryParam("metric")).setOperator(request.mandatoryParam("op")).setWarning(request.param("warning")).setError(request.param("error")).setPeriod(request.paramAsInt("period")).build();
    }
}

