/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectlink.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Slug;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.projectlink.ws.ProjectLinksWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsProjectLinks;
import org.sonarqube.ws.client.projectlinks.CreateWsRequest;

public class CreateAction
implements ProjectLinksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private static final int LINK_NAME_MAX_LENGTH = 128;
    private static final int LINK_URL_MAX_LENGTH = 2048;
    private static final int LINK_TYPE_MAX_LENGTH = 20;

    public CreateAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create").setDescription("Create a new project link.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setHandler((RequestHandler)this).setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setSince("6.1");
        action.createParam("projectId").setDescription("Project id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project");
        action.createParam("name").setRequired(true).setDescription("Link name").setExampleValue((Object)"Custom");
        action.createParam("url").setRequired(true).setDescription("Link url").setExampleValue((Object)"http://example.com");
    }

    public void handle(Request request, Response response) throws Exception {
        CreateWsRequest searchWsRequest = CreateAction.toCreateWsRequest(request);
        WsProjectLinks.CreateWsResponse createWsResponse = this.doHandle(searchWsRequest);
        WsUtils.writeProtobuf((Message)createWsResponse, request, response);
    }

    private WsProjectLinks.CreateWsResponse doHandle(CreateWsRequest createWsRequest) {
        CreateAction.validateRequest(createWsRequest);
        String name = createWsRequest.getName();
        String url = createWsRequest.getUrl();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.getComponentByUuidOrKey(dbSession, createWsRequest);
            this.userSession.checkComponentPermission("admin", component);
            ComponentLinkDto link = new ComponentLinkDto().setComponentUuid(component.uuid()).setName(name).setHref(url).setType(CreateAction.nameToType(name));
            this.dbClient.componentLinkDao().insert(dbSession, link);
            dbSession.commit();
            WsProjectLinks.CreateWsResponse createWsResponse = CreateAction.buildResponse(link);
            return createWsResponse;
        }
    }

    private static WsProjectLinks.CreateWsResponse buildResponse(ComponentLinkDto link) {
        return WsProjectLinks.CreateWsResponse.newBuilder().setLink(WsProjectLinks.Link.newBuilder().setId(String.valueOf(link.getId())).setName(link.getName()).setType(link.getType()).setUrl(link.getHref())).build();
    }

    private ComponentDto getComponentByUuidOrKey(DbSession dbSession, CreateWsRequest request) {
        return this.componentFinder.getRootComponentByUuidOrKey(dbSession, request.getProjectId(), request.getProjectKey(), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
    }

    private static CreateWsRequest toCreateWsRequest(Request request) {
        return new CreateWsRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey")).setName(request.mandatoryParam("name")).setUrl(request.mandatoryParam("url"));
    }

    private static void validateRequest(CreateWsRequest request) {
        Preconditions.checkArgument((request.getName().length() <= 128 ? 1 : 0) != 0, (String)"Link name cannot be longer than %s characters", (Object[])new Object[]{128});
        Preconditions.checkArgument((request.getUrl().length() <= 2048 ? 1 : 0) != 0, (String)"Link url cannot be longer than %s characters", (Object[])new Object[]{2048});
    }

    private static String nameToType(String name) {
        String slugified = Slug.slugify((String)name);
        return slugified.substring(0, Math.min(slugified.length(), 20));
    }
}

