/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentUpdater;
import org.sonar.server.component.NewComponent;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsProjects;
import org.sonarqube.ws.client.project.CreateRequest;

public class CreateAction
implements ProjectsWsAction {
    private static final String DEPRECATED_PARAM_KEY = "key";
    private final ProjectsWsSupport support;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentUpdater componentUpdater;

    public CreateAction(ProjectsWsSupport support, DbClient dbClient, UserSession userSession, ComponentUpdater componentUpdater) {
        this.support = support;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentUpdater = componentUpdater;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create").setDescription("Create a project.<br/>Requires 'Create Projects' permission").setSince("4.0").setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.3", "The response format has been updated and does not contain the database ID anymore"), new Change("6.3", "The 'key' parameter has been renamed 'project'")});
        action.createParam("project").setDescription("Key of the project").setDeprecatedKey(DEPRECATED_PARAM_KEY, "6.3").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam("name").setDescription("Name of the project").setRequired(true).setExampleValue((Object)"SonarQube");
        action.createParam("branch").setDescription("SCM Branch of the project. The key of the project will become key:branch, for instance 'SonarQube:branch-5.0'").setExampleValue((Object)"branch-5.0");
        action.createParam("visibility").setDescription("Whether the created project should be visible to everyone, or only specific user/groups.<br/>If no visibility is specified, the default project visibility of the organization will be used.").setRequired(false).setInternal(true).setSince("6.4").setPossibleValues(Visibility.getLabels());
        this.support.addOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        CreateRequest createRequest = CreateAction.toCreateRequest(request);
        WsUtils.writeProtobuf((Message)this.doHandle(createRequest), request, response);
    }

    private WsProjects.CreateWsResponse doHandle(CreateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.getOrganization(dbSession, request.getOrganization());
            this.userSession.checkPermission(OrganizationPermission.PROVISION_PROJECTS, organization);
            String visibility = request.getVisibility();
            Boolean changeToPrivate = visibility == null ? this.dbClient.organizationDao().getNewProjectPrivate(dbSession, organization) : "private".equals(visibility);
            this.support.checkCanUpdateProjectsVisibility(organization, changeToPrivate);
            ComponentDto componentDto = this.componentUpdater.create(dbSession, NewComponent.newComponentBuilder().setOrganizationUuid(organization.getUuid()).setKey(request.getKey()).setName(request.getName()).setBranch(request.getBranch()).setPrivate(changeToPrivate).setQualifier("TRK").build(), this.userSession.isLoggedIn() ? this.userSession.getUserId() : null);
            WsProjects.CreateWsResponse createWsResponse = CreateAction.toCreateResponse(componentDto);
            return createWsResponse;
        }
    }

    private static CreateRequest toCreateRequest(Request request) {
        return CreateRequest.builder().setOrganization(request.param("organization")).setKey(request.mandatoryParam("project")).setName(request.mandatoryParam("name")).setBranch(request.param("branch")).setVisibility(request.param("visibility")).build();
    }

    private static WsProjects.CreateWsResponse toCreateResponse(ComponentDto componentDto) {
        return WsProjects.CreateWsResponse.newBuilder().setProject(WsProjects.CreateWsResponse.Project.newBuilder().setKey(componentDto.getDbKey()).setName(componentDto.name()).setQualifier(componentDto.qualifier()).setVisibility(Visibility.getLabel(componentDto.isPrivate()))).build();
    }
}

