/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.Resources;
import java.util.Collection;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.UpdateCenter;

public class AvailableAction
implements PluginsWsAction {
    private static final boolean DO_NOT_FORCE_REFRESH = false;
    private static final String ARRAY_PLUGINS = "plugins";
    private final UserSession userSession;
    private final UpdateCenterMatrixFactory updateCenterFactory;
    private final PluginWSCommons pluginWSCommons;

    public AvailableAction(UserSession userSession, UpdateCenterMatrixFactory updateCenterFactory, PluginWSCommons pluginWSCommons) {
        this.userSession = userSession;
        this.updateCenterFactory = updateCenterFactory;
        this.pluginWSCommons = pluginWSCommons;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("available").setDescription("Get the list of all the plugins available for installation on the SonarQube instance, sorted by plugin name.<br/>Plugin information is retrieved from Update Center. Date and time at which Update Center was last refreshed is provided in the response.<br/>Update status values are: <ul><li>COMPATIBLE: plugin is compatible with current SonarQube instance.</li><li>INCOMPATIBLE: plugin is not compatible with current SonarQube instance.</li><li>REQUIRES_SYSTEM_UPGRADE: plugin requires SonarQube to be upgraded before being installed.</li><li>DEPS_REQUIRE_SYSTEM_UPGRADE: at least one plugin on which the plugin is dependent requires SonarQube to be upgraded.</li></ul>Require 'Administer System' permission.").setSince("5.2").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-available_plugins.json"));
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        JsonWriter jsonWriter = response.newJsonWriter();
        jsonWriter.beginObject();
        Optional<UpdateCenter> updateCenter = this.updateCenterFactory.getUpdateCenter(false);
        this.writePlugins(jsonWriter, updateCenter);
        this.pluginWSCommons.writeUpdateCenterProperties(jsonWriter, updateCenter);
        jsonWriter.endObject();
        jsonWriter.close();
    }

    private void writePlugins(JsonWriter jsonWriter, Optional<UpdateCenter> updateCenter) {
        jsonWriter.name(ARRAY_PLUGINS).beginArray();
        if (updateCenter.isPresent()) {
            for (PluginUpdate pluginUpdate : AvailableAction.retrieveAvailablePlugins((UpdateCenter)updateCenter.get())) {
                this.pluginWSCommons.writePluginUpdate(jsonWriter, pluginUpdate);
            }
        }
        jsonWriter.endArray();
    }

    private static Collection<PluginUpdate> retrieveAvailablePlugins(UpdateCenter updateCenter) {
        return ImmutableSortedSet.copyOf(PluginWSCommons.NAME_KEY_PLUGIN_UPDATE_ORDERING, (Collection)updateCenter.findAvailablePlugins());
    }
}

