/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.base.Optional;
import org.sonar.api.SonarRuntime;
import org.sonar.server.plugins.InstalledPluginReferentialFactory;
import org.sonar.server.plugins.UpdateCenterClient;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public class UpdateCenterMatrixFactory {
    private final UpdateCenterClient centerClient;
    private final SonarRuntime sonarRuntime;
    private final InstalledPluginReferentialFactory installedPluginReferentialFactory;

    public UpdateCenterMatrixFactory(UpdateCenterClient centerClient, SonarRuntime runtime, InstalledPluginReferentialFactory installedPluginReferentialFactory) {
        this.centerClient = centerClient;
        this.sonarRuntime = runtime;
        this.installedPluginReferentialFactory = installedPluginReferentialFactory;
    }

    public Optional<UpdateCenter> getUpdateCenter(boolean refreshUpdateCenter) {
        Optional<UpdateCenter> updateCenter = this.centerClient.getUpdateCenter(refreshUpdateCenter);
        if (updateCenter.isPresent()) {
            org.sonar.api.utils.Version fullVersion = this.sonarRuntime.getApiVersion();
            org.sonar.api.utils.Version semanticVersion = org.sonar.api.utils.Version.create((int)fullVersion.major(), (int)fullVersion.minor(), (int)fullVersion.patch());
            return Optional.of((Object)((UpdateCenter)updateCenter.get()).setInstalledSonarVersion(Version.create((String)semanticVersion.toString())).registerInstalledPlugins(this.installedPluginReferentialFactory.getInstalledPluginReferential()).setDate(this.centerClient.getLastRefreshDate()));
        }
        return Optional.absent();
    }
}

