/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.h2.Driver;
import org.h2.tools.Server;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class EmbeddedDatabase
implements Startable {
    private static final Logger LOG = Loggers.get(EmbeddedDatabase.class);
    private final Configuration config;
    private final System2 system2;
    private Server server;

    public EmbeddedDatabase(Configuration config, System2 system2) {
        this.config = config;
        this.system2 = system2;
    }

    public void start() {
        File dbHome = new File(this.getRequiredSetting("sonar.path.data"));
        if (!dbHome.exists()) {
            dbHome.mkdirs();
        }
        this.startServer(dbHome);
    }

    private void startServer(File dbHome) {
        String url = this.getRequiredSetting("sonar.jdbc.url");
        String port = this.getRequiredSetting("sonar.embeddedDatabase.port");
        String user = this.getSetting("sonar.jdbc.username", "");
        String password = this.getSetting("sonar.jdbc.password", "");
        try {
            this.system2.setProperty("h2.bindAddress", InetAddress.getLoopbackAddress().getHostAddress());
            if (url.contains("/mem:")) {
                this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-baseDir", dbHome.getAbsolutePath()});
            } else {
                EmbeddedDatabase.createDatabase(dbHome, user, password);
                this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-ifExists", "-baseDir", dbHome.getAbsolutePath()});
            }
            LOG.info("Starting embedded database on port " + this.server.getPort() + " with url " + url);
            this.server.start();
            LOG.info("Embedded database started. Data stored in: " + dbHome.getAbsolutePath());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to start database", e);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            LOG.info("Embedded database stopped");
        }
    }

    private String getRequiredSetting(String property) {
        String value = this.config.get(property).orElse("");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)value), (String)"Missing property %s", (Object[])new Object[]{property});
        return value;
    }

    private String getSetting(String name, String defaultValue) {
        return StringUtils.defaultIfBlank((String)this.config.get(name).orElse(""), (String)defaultValue);
    }

    private static void createDatabase(File dbHome, String user, String password) throws SQLException {
        String url = String.format("jdbc:h2:%s/sonar;USER=%s;PASSWORD=%s", dbHome.getAbsolutePath(), user, password);
        DriverManager.registerDriver((java.sql.Driver)new Driver());
        DriverManager.getConnection(url).close();
    }
}

