/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonar.api.SonarRuntime;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class LogServerVersion
implements Startable {
    private static final Logger LOG = Loggers.get(LogServerVersion.class);
    private final SonarRuntime runtime;

    public LogServerVersion(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    public void start() {
        String scmRevision = LogServerVersion.read("/build.properties").getProperty("Implementation-Build");
        Version version = this.runtime.getApiVersion();
        LOG.info("SonarQube {}", (Object)Joiner.on((String)" / ").skipNulls().join((Object)"Server", (Object)version, new Object[]{scmRevision}));
    }

    public void stop() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties read(String filePath) {
        try (InputStream stream = LogServerVersion.class.getResourceAsStream(filePath);){
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to read file " + filePath + " from classpath", e);
        }
    }
}

