/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.permission.template.PermissionTemplateGroupDto;
import org.sonar.db.user.GroupDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsPermissions;

public class TemplateGroupsAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionWsSupport support;

    public TemplateGroupsAction(DbClient dbClient, UserSession userSession, PermissionWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("template_groups").setSince("5.2").setInternal(true).setDescription("Lists the groups with their permission as individual groups rather than through user affiliation on the chosen template.<br />This service defaults to all groups, but can be limited to groups with a specific permission by providing the desired permission.<br>Requires the following permission: 'Administer System'.").addPagingParams(20, 100).setResponseExample(this.getClass().getResource("template_groups-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to group names that contain the supplied string. Must have at least %d characters.<br/>When this parameter is not set, only group having at least one permission are returned.", new Object[]{3}).setExampleValue((Object)"eri");
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            WsTemplateRef templateRef = WsTemplateRef.fromRequest(wsRequest);
            PermissionTemplateDto template = this.support.findTemplate(dbSession, templateRef);
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            PermissionQuery query = TemplateGroupsAction.buildPermissionQuery(wsRequest, template);
            int total = this.dbClient.permissionTemplateDao().countGroupNamesByQueryAndTemplate(dbSession, query, template.getOrganizationUuid(), template.getId().longValue());
            Paging paging = Paging.forPageIndex((int)wsRequest.mandatoryParamAsInt("p")).withPageSize(wsRequest.mandatoryParamAsInt("ps")).andTotal(total);
            List<GroupDto> groups = this.findGroups(dbSession, query, template);
            List<PermissionTemplateGroupDto> groupPermissions = this.findGroupPermissions(dbSession, groups, template);
            WsPermissions.WsGroupsResponse groupsResponse = TemplateGroupsAction.buildResponse(groups, groupPermissions, paging);
            WsUtils.writeProtobuf((Message)groupsResponse, wsRequest, wsResponse);
        }
    }

    private static PermissionQuery buildPermissionQuery(Request request, PermissionTemplateDto template) {
        String textQuery = request.param("q");
        String permission = request.param("permission");
        PermissionQuery.Builder permissionQuery = PermissionQuery.builder().setOrganizationUuid(template.getOrganizationUuid()).setPermission(permission != null ? PermissionRequestValidator.validateProjectPermission(permission) : null).setPageIndex(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).setSearchQuery(textQuery);
        if (textQuery == null) {
            permissionQuery.withAtLeastOnePermission();
        }
        return permissionQuery.build();
    }

    private static WsPermissions.WsGroupsResponse buildResponse(List<GroupDto> groups, List<PermissionTemplateGroupDto> groupPermissions, Paging paging) {
        TreeMultimap permissionsByGroupId = TreeMultimap.create();
        groupPermissions.forEach(arg_0 -> TemplateGroupsAction.lambda$buildResponse$0((Multimap)permissionsByGroupId, arg_0));
        WsPermissions.WsGroupsResponse.Builder response = WsPermissions.WsGroupsResponse.newBuilder();
        groups.forEach(arg_0 -> TemplateGroupsAction.lambda$buildResponse$1(response, (Multimap)permissionsByGroupId, arg_0));
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total());
        return response.build();
    }

    private List<GroupDto> findGroups(DbSession dbSession, PermissionQuery dbQuery, PermissionTemplateDto template) {
        List orderedNames = this.dbClient.permissionTemplateDao().selectGroupNamesByQueryAndTemplate(dbSession, dbQuery, template.getId().longValue());
        List groups = this.dbClient.groupDao().selectByNames(dbSession, template.getOrganizationUuid(), (Collection)orderedNames);
        if (orderedNames.contains("Anyone")) {
            groups.add(0, new GroupDto().setId(Integer.valueOf(0)).setName("Anyone"));
        }
        return Ordering.explicit((List)orderedNames).onResultOf(GroupDto::getName).immutableSortedCopy((Iterable)groups);
    }

    private List<PermissionTemplateGroupDto> findGroupPermissions(DbSession dbSession, List<GroupDto> groups, PermissionTemplateDto template) {
        List names = groups.stream().map(GroupDto::getName).collect(Collectors.toList());
        return this.dbClient.permissionTemplateDao().selectGroupPermissionsByTemplateIdAndGroupNames(dbSession, template.getId().longValue(), names);
    }

    private static /* synthetic */ void lambda$buildResponse$1(WsPermissions.WsGroupsResponse.Builder response, Multimap permissionsByGroupId, GroupDto group) {
        WsPermissions.Group.Builder wsGroup = response.addGroupsBuilder().setName(group.getName());
        if (group.getId() != 0) {
            wsGroup.setId(String.valueOf(group.getId()));
        }
        Protobuf.setNullable((Object)group.getDescription(), arg_0 -> ((WsPermissions.Group.Builder)wsGroup).setDescription(arg_0));
        wsGroup.addAllPermissions((Iterable)permissionsByGroupId.get((Object)group.getId()));
    }

    private static /* synthetic */ void lambda$buildResponse$0(Multimap permissionsByGroupId, PermissionTemplateGroupDto groupPermission) {
        permissionsByGroupId.put((Object)groupPermission.getGroupId(), (Object)groupPermission.getPermission());
    }
}

