/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.permission.AddUserToTemplateWsRequest;

public class AddUserToTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;

    public AddUserToTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    private static AddUserToTemplateWsRequest toAddUserToTemplateWsRequest(Request request) {
        return new AddUserToTemplateWsRequest().setLogin(request.mandatoryParam("login")).setPermission(request.mandatoryParam("permission")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_user_to_template").setPost(true).setSince("5.2").setDescription("Add a user to a permission template.<br /> Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createUserLoginParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(AddUserToTemplateAction.toAddUserToTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(AddUserToTemplateWsRequest request) {
        String permission = request.getPermission();
        String userLogin = request.getLogin();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            OrganizationDto organizationDto = this.wsSupport.findOrganization(dbSession, request.getOrganization());
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, organizationDto.getUuid());
            UserId user = this.wsSupport.findUser(dbSession, userLogin);
            this.wsSupport.checkMembership(dbSession, organizationDto, user);
            if (!this.isUserAlreadyAdded(dbSession, organizationDto, template.getId(), userLogin, permission)) {
                this.dbClient.permissionTemplateDao().insertUserPermission(dbSession, template.getId(), Integer.valueOf(user.getId()), permission);
                dbSession.commit();
            }
        }
    }

    private boolean isUserAlreadyAdded(DbSession dbSession, OrganizationDto organizationDto, long templateId, String userLogin, String permission) {
        PermissionQuery permissionQuery = PermissionQuery.builder().setOrganizationUuid(organizationDto.getUuid()).setPermission(permission).build();
        List usersWithPermission = this.dbClient.permissionTemplateDao().selectUserLoginsByQueryAndTemplate(dbSession, permissionQuery, templateId);
        return usersWithPermission.stream().anyMatch(s -> s.equals(userLogin));
    }
}

