/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.SearchResult;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndex;
import org.sonar.server.user.index.UserQuery;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Organizations;

public class SearchMembersAction
implements OrganizationsWsAction {
    private final DbClient dbClient;
    private final UserIndex userIndex;
    private final DefaultOrganizationProvider organizationProvider;
    private final UserSession userSession;
    private final AvatarResolver avatarResolver;

    public SearchMembersAction(DbClient dbClient, UserIndex userIndex, DefaultOrganizationProvider organizationProvider, UserSession userSession, AvatarResolver avatarResolver) {
        this.dbClient = dbClient;
        this.userIndex = userIndex;
        this.organizationProvider = organizationProvider;
        this.userSession = userSession;
        this.avatarResolver = avatarResolver;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_members").setDescription("Search members of an organization").setResponseExample(this.getClass().getResource("search_members-example.json")).setSince("6.4").setInternal(true).setHandler((RequestHandler)this);
        action.addSearchQuery("orwe", new String[]{"names", "logins"});
        action.addPagingParams(50, 500);
        action.createParam("selected").setDescription("Depending on the value, show only selected items (selected=selected) or deselected items (selected=deselected).").setInternal(true).setDefaultValue((Object)WebService.SelectionMode.SELECTED.value()).setPossibleValues(new Object[]{WebService.SelectionMode.SELECTED.value(), WebService.SelectionMode.DESELECTED.value()});
        action.createParam("organization").setDescription("Organization key").setInternal(true).setRequired(false);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.getOrganization(dbSession, request.param("organization"));
            UserQuery.Builder userQuery = SearchMembersAction.buildUserQuery(request, organization);
            SearchOptions searchOptions = SearchMembersAction.buildSearchOptions(request);
            SearchResult<UserDoc> searchResults = this.userIndex.search(userQuery.build(), searchOptions);
            List orderedLogins = (List)searchResults.getDocs().stream().map(UserDoc::login).collect(MoreCollectors.toList());
            List users = (List)this.dbClient.userDao().selectByLogins(dbSession, (Collection)orderedLogins).stream().sorted(Ordering.explicit((List)orderedLogins).onResultOf(UserDto::getLogin)).collect(MoreCollectors.toList());
            Multiset groupCountByLogin = null;
            if (this.userSession.hasPermission(OrganizationPermission.ADMINISTER, organization)) {
                groupCountByLogin = this.dbClient.groupMembershipDao().countGroupByLoginsAndOrganization(dbSession, (Collection)orderedLogins, organization.getUuid());
            }
            Common.Paging wsPaging = SearchMembersAction.buildWsPaging(request, searchResults);
            Organizations.SearchMembersWsResponse wsResponse = this.buildResponse(users, wsPaging, (Multiset<String>)groupCountByLogin);
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private Organizations.SearchMembersWsResponse buildResponse(List<UserDto> users, Common.Paging wsPaging, @Nullable Multiset<String> groupCountByLogin) {
        Organizations.SearchMembersWsResponse.Builder response = Organizations.SearchMembersWsResponse.newBuilder();
        Organizations.User.Builder wsUser = Organizations.User.newBuilder();
        users.stream().map(userDto -> {
            String login = userDto.getLogin();
            wsUser.clear().setLogin(login).setName(userDto.getName());
            Protobuf.setNullable((Object)Strings.emptyToNull((String)userDto.getEmail()), text -> wsUser.setAvatar(this.avatarResolver.create((UserDto)userDto)));
            Protobuf.setNullable((Object)groupCountByLogin, count -> wsUser.setGroupCount(groupCountByLogin.count((Object)login)));
            return wsUser;
        }).forEach(arg_0 -> ((Organizations.SearchMembersWsResponse.Builder)response).addUsers(arg_0));
        response.setPaging(wsPaging);
        return response.build();
    }

    private static UserQuery.Builder buildUserQuery(Request request, OrganizationDto organization) {
        UserQuery.Builder userQuery = UserQuery.builder();
        String textQuery = request.param("q");
        Preconditions.checkArgument((textQuery == null || textQuery.length() >= 2 ? 1 : 0) != 0, (Object)"Query length must be greater than or equal to 2");
        userQuery.setTextQuery(textQuery);
        WebService.SelectionMode selectionMode = WebService.SelectionMode.fromParam((String)request.mandatoryParam("selected"));
        if (WebService.SelectionMode.DESELECTED.equals((Object)selectionMode)) {
            userQuery.setExcludedOrganizationUuid(organization.getUuid());
        } else {
            userQuery.setOrganizationUuid(organization.getUuid());
        }
        return userQuery;
    }

    private static SearchOptions buildSearchOptions(Request request) {
        int pageSize = request.mandatoryParamAsInt("ps");
        Preconditions.checkArgument((pageSize <= 500 ? 1 : 0) != 0, (String)"Page size must lower than or equal to %s", (Object[])new Object[]{500});
        return new SearchOptions().setPage(request.mandatoryParamAsInt("p"), pageSize);
    }

    private static Common.Paging buildWsPaging(Request request, SearchResult<UserDoc> searchResults) {
        return Common.Paging.newBuilder().setPageIndex(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setTotal((int)searchResults.getTotal()).build();
    }

    private OrganizationDto getOrganization(DbSession dbSession, @Nullable String organizationParam) {
        String organizationKey = Optional.ofNullable(organizationParam).orElseGet(this.organizationProvider.get()::getKey);
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization with key '%s'", organizationKey);
    }
}

