/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationQuery;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Organizations;

public class SearchAction
implements OrganizationsWsAction {
    private static final String PARAM_ORGANIZATIONS = "organizations";
    private static final String ACTION = "search";
    private final DbClient dbClient;
    private final OrganizationsWsSupport wsSupport;

    public SearchAction(DbClient dbClient, OrganizationsWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(false).setDescription("Search for organizations").setResponseExample(this.getClass().getResource("search-example.json")).setInternal(true).setSince("6.2").setChangelog(new Change[]{new Change("6.4", "Paging fields have been added to the response")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_ORGANIZATIONS).setDescription("Comma-separated list of organization keys").setExampleValue((Object)String.join((CharSequence)",", "my-org-1", "foocorp")).setRequired(false).setSince("6.3");
        action.addPagingParams(25);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationQuery organizationQuery = OrganizationQuery.newOrganizationQueryBuilder().setKeys((Collection)request.paramAsStrings(PARAM_ORGANIZATIONS)).build();
            int total = this.dbClient.organizationDao().countByQuery(dbSession, organizationQuery);
            Common.Paging paging = SearchAction.buildWsPaging(request, total);
            List dtos = this.dbClient.organizationDao().selectByQuery(dbSession, organizationQuery, Pagination.forPage((int)paging.getPageIndex()).andSize(paging.getPageSize()));
            this.writeResponse(request, response, dtos, paging);
        }
    }

    private void writeResponse(Request request, Response response, List<OrganizationDto> dtos, Common.Paging paging) {
        Organizations.SearchWsResponse.Builder responseBuilder = Organizations.SearchWsResponse.newBuilder();
        responseBuilder.setPaging(paging);
        Organizations.Organization.Builder organizationBuilder = Organizations.Organization.newBuilder();
        dtos.forEach(dto -> responseBuilder.addOrganizations(this.wsSupport.toOrganization(organizationBuilder, (OrganizationDto)dto)));
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }

    private static Common.Paging buildWsPaging(Request request, int total) {
        return Common.Paging.newBuilder().setPageIndex(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setTotal(total).build();
    }
}

