/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;

public interface OrganizationCreation {
    public static final String OWNERS_GROUP_NAME = "Owners";
    public static final String OWNERS_GROUP_DESCRIPTION_PATTERN = "Owners of organization %s";
    public static final String PERM_TEMPLATE_NAME = "Default template";
    public static final String PERM_TEMPLATE_DESCRIPTION_PATTERN = "Default permission template of organization %s";
    public static final String PERSONAL_ORGANIZATION_DESCRIPTION_PATTERN = "%s's personal organization";

    public OrganizationDto create(DbSession var1, UserDto var2, NewOrganization var3) throws KeyConflictException;

    public Optional<OrganizationDto> createForUser(DbSession var1, UserDto var2);

    public static final class NewOrganization {
        private final String key;
        private final String name;
        @CheckForNull
        private final String description;
        @CheckForNull
        private final String url;
        @CheckForNull
        private final String avatar;

        private NewOrganization(Builder builder) {
            this.key = builder.key;
            this.name = builder.name;
            this.description = builder.description;
            this.url = builder.url;
            this.avatar = builder.avatarUrl;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        @CheckForNull
        public String getUrl() {
            return this.url;
        }

        @CheckForNull
        public String getAvatar() {
            return this.avatar;
        }

        public static Builder newOrganizationBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String name;
            private String description;
            private String url;
            private String avatarUrl;

            private Builder() {
            }

            public Builder setKey(String key) {
                this.key = Objects.requireNonNull(key, "key can't be null");
                return this;
            }

            public Builder setName(String name) {
                this.name = Objects.requireNonNull(name, "name can't be null");
                return this;
            }

            public Builder setDescription(@Nullable String description) {
                this.description = description;
                return this;
            }

            public Builder setUrl(@Nullable String url) {
                this.url = url;
                return this;
            }

            public Builder setAvatarUrl(@Nullable String avatarUrl) {
                this.avatarUrl = avatarUrl;
                return this;
            }

            public NewOrganization build() {
                Objects.requireNonNull(this.key, "key can't be null");
                Objects.requireNonNull(this.name, "name can't be null");
                return new NewOrganization(this);
            }
        }
    }

    public static final class KeyConflictException
    extends Exception {
        KeyConflictException(String message) {
            super(message);
        }
    }
}

