/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.Table;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.ComponentTreeData;
import org.sonarqube.ws.client.measure.ComponentTreeWsRequest;

class HasMeasure
implements Predicate<ComponentDto> {
    private final Predicate<ComponentDto> predicate;

    HasMeasure(Table<String, MetricDto, ComponentTreeData.Measure> table, MetricDto metric, ComponentTreeWsRequest request) {
        Integer periodIndex = request.getMetricPeriodSort();
        this.predicate = periodIndex == null ? new HasAbsoluteValue(table, metric) : new HasValueOnPeriod(table, metric);
    }

    @Override
    public boolean test(@Nonnull ComponentDto input) {
        return this.predicate.test(input);
    }

    private static class HasValueOnPeriod
    implements Predicate<ComponentDto> {
        private final Table<String, MetricDto, ComponentTreeData.Measure> table;
        private final MetricDto metric;

        private HasValueOnPeriod(Table<String, MetricDto, ComponentTreeData.Measure> table, MetricDto metric) {
            this.table = table;
            this.metric = metric;
        }

        @Override
        public boolean test(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.table.get((Object)input.uuid(), (Object)this.metric);
            return measure != null && measure.isVariationSet();
        }
    }

    private static class HasAbsoluteValue
    implements Predicate<ComponentDto> {
        private final Table<String, MetricDto, ComponentTreeData.Measure> table;
        private final MetricDto metric;

        private HasAbsoluteValue(Table<String, MetricDto, ComponentTreeData.Measure> table, MetricDto metric) {
            this.table = table;
            this.metric = metric;
        }

        @Override
        public boolean test(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.table.get((Object)input.uuid(), (Object)this.metric);
            return measure != null && (measure.isValueSet() || measure.getData() != null);
        }
    }
}

