/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.issue.IssueQuery;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.ws.IssuesWsAction;

public class AuthorsAction
implements IssuesWsAction {
    private final IssueIndex issueIndex;

    public AuthorsAction(IssueIndex issueIndex) {
        this.issueIndex = issueIndex;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("authors").setSince("5.1").setDescription("Search SCM accounts which match a given query").setResponseExample(Resources.getResource(this.getClass(), (String)"authors-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("A pattern to match SCM accounts against").setExampleValue((Object)"luke");
        action.createParam("ps").setDescription("The size of the list to return").setExampleValue((Object)"25").setDefaultValue((Object)"10");
    }

    public void handle(Request request, Response response) throws Exception {
        String query = request.param("q");
        int pageSize = request.mandatoryParamAsInt("ps");
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("authors").beginArray();
            for (String login : this.listAuthors(query, pageSize)) {
                json.value(login);
            }
            json.endArray().endObject();
        }
    }

    public List<String> listAuthors(@Nullable String textQuery, int pageSize) {
        return this.issueIndex.listAuthors(IssueQuery.builder().checkAuthorization(false).build(), textQuery, pageSize);
    }
}

