/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.TransitionService;
import org.sonar.server.issue.workflow.Transition;
import org.sonar.server.user.UserSession;

@ServerSide
public class TransitionAction
extends Action {
    public static final String DO_TRANSITION_KEY = "do_transition";
    public static final String TRANSITION_PARAMETER = "transition";
    private final TransitionService transitionService;

    public TransitionAction(TransitionService transitionService) {
        super(DO_TRANSITION_KEY);
        this.transitionService = transitionService;
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        TransitionAction.transition(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        String transition;
        DefaultIssue issue = context.issue();
        return this.canExecuteTransition(issue, transition = TransitionAction.transition(properties)) && this.transitionService.doTransition(context.issue(), context.issueChangeContext(), TransitionAction.transition(properties));
    }

    private boolean canExecuteTransition(DefaultIssue issue, String transitionKey) {
        return ((Set)this.transitionService.listTransitions(issue).stream().map(Transition::key).collect(MoreCollectors.toSet())).contains(transitionKey);
    }

    private static String transition(Map<String, Object> properties) {
        String param = (String)properties.get(TRANSITION_PARAMETER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)param) ? 1 : 0) != 0, (Object)"Missing parameter : 'transition'");
        return param;
    }
}

