/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import java.util.Objects;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;

public class IssueFinder {
    private final DbClient dbClient;
    private final UserSession userSession;

    public IssueFinder(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public IssueDto getByKey(DbSession session, String issueKey) {
        IssueDto issue = (IssueDto)this.dbClient.issueDao().selectByKey(session, issueKey).orElseThrow(() -> new NotFoundException(String.format("Issue with key '%s' does not exist", issueKey)));
        this.userSession.checkComponentUuidPermission("user", Objects.requireNonNull(issue.getProjectUuid()));
        return issue;
    }
}

