/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Health {
    public static final Health GREEN = Health.newHealthCheckBuilder().setStatus(Status.GREEN).build();
    private final Status status;
    private final Set<String> causes;

    public Health(Builder builder) {
        this.status = builder.status;
        this.causes = ImmutableSet.copyOf((Collection)builder.causes);
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<String> getCauses() {
        return this.causes;
    }

    public static Builder newHealthCheckBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Health health = (Health)o;
        return this.status == health.status && Objects.equals(this.causes, health.causes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.causes});
    }

    public String toString() {
        return "Health{" + (Object)((Object)this.status) + ", causes=" + this.causes + '}';
    }

    public static enum Status {
        GREEN,
        YELLOW,
        RED;

    }

    public static class Builder {
        private Status status;
        private Set<String> causes = new HashSet<String>(0);

        private Builder() {
        }

        public Builder clear() {
            this.status = null;
            this.causes.clear();
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = Builder.checkStatus(status);
            return this;
        }

        public Builder addCause(String cause) {
            Objects.requireNonNull(cause, "cause can't be null");
            Preconditions.checkArgument((!cause.trim().isEmpty() ? 1 : 0) != 0, (Object)"cause can't be empty");
            this.causes.add(cause);
            return this;
        }

        public Health build() {
            Builder.checkStatus(this.status);
            return new Health(this);
        }

        private static Status checkStatus(Status status) {
            return Objects.requireNonNull(status, "status can't be null");
        }
    }
}

