/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.IsAliveMapper;
import org.sonar.server.health.Health;
import org.sonar.server.health.NodeHealthCheck;

public class DbConnectionNodeCheck
implements NodeHealthCheck {
    private static final Logger LOGGER = Loggers.get(DbConnectionNodeCheck.class);
    private static final Health RED_HEALTH = Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("Can't connect to DB").build();
    private final DbClient dbClient;

    public DbConnectionNodeCheck(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public Health check() {
        if (this.isConnectedToDB()) {
            return Health.GREEN;
        }
        return RED_HEALTH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnectedToDB() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            boolean bl = ((IsAliveMapper)dbSession.getMapper(IsAliveMapper.class)).isAlive() == 1;
            return bl;
        }
        catch (RuntimeException e) {
            LOGGER.trace("DB connection is down: {}", (Object)e);
            return false;
        }
    }
}

