/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.server.ws.WsUtils;

public class FavoriteUpdater {
    static final String PROP_FAVORITE_KEY = "favourite";
    private final DbClient dbClient;

    public FavoriteUpdater(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void add(DbSession dbSession, ComponentDto componentDto, @Nullable Integer userId) {
        if (userId == null) {
            return;
        }
        List existingFavoriteOnComponent = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey(PROP_FAVORITE_KEY).setUserId(userId).setComponentId(componentDto.getId()).build(), dbSession);
        WsUtils.checkRequest(existingFavoriteOnComponent.isEmpty(), "Component '%s' is already a favorite", componentDto.getDbKey());
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey(PROP_FAVORITE_KEY).setResourceId(componentDto.getId()).setUserId(userId));
    }

    public void remove(DbSession dbSession, ComponentDto component, @Nullable Integer userId) {
        if (userId == null) {
            return;
        }
        int result = this.dbClient.propertiesDao().delete(dbSession, new PropertyDto().setKey(PROP_FAVORITE_KEY).setResourceId(component.getId()).setUserId(userId));
        WsUtils.checkRequest(result == 1, "Component '%s' is not a favorite", component.getDbKey());
    }
}

