/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyIndexRequestBuilder
extends IndexRequestBuilder {
    public ProxyIndexRequestBuilder(Client client) {
        super((ElasticsearchClient)client, IndexAction.INSTANCE);
    }

    public IndexResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            IndexResponse indexResponse = (IndexResponse)super.execute().actionGet();
            return indexResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public IndexResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public IndexResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<IndexResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder().append("ES index request");
        message.append(String.format(" for key '%s'", ((IndexRequest)this.request).id()));
        message.append(String.format(" on index '%s'", ((IndexRequest)this.request).index()));
        message.append(String.format(" on type '%s'", ((IndexRequest)this.request).type()));
        return message.toString();
    }
}

